/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.art;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.AssumeEdge;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.cpa.art.ARTElement;
import org.sosy_lab.cpachecker.cpa.art.Path;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonState;
import org.sosy_lab.cpachecker.cpa.explicit.ExplicitElement;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractElement;
import org.sosy_lab.cpachecker.util.AbstractElements;

public class ARTUtils {
    private ARTUtils() {
    }

    public static Set<ARTElement> getAllElementsOnPathsTo(ARTElement pLastElement) {
        HashSet<ARTElement> result = new HashSet<ARTElement>();
        ArrayDeque<ARTElement> waitList = new ArrayDeque<ARTElement>();
        result.add(pLastElement);
        waitList.add(pLastElement);
        while (!waitList.isEmpty()) {
            ARTElement currentElement = (ARTElement)waitList.poll();
            for (ARTElement parent : currentElement.getParents()) {
                if (!result.add(parent)) continue;
                waitList.push(parent);
            }
        }
        return result;
    }

    public static Path getOnePathTo(ARTElement pLastElement) {
        Path path = new Path();
        HashSet<ARTElement> seenElements = new HashSet<ARTElement>();
        ARTElement currentARTElement = pLastElement;
        assert (pLastElement.isTarget());
        CFANode loc = AbstractElements.extractLocation(currentARTElement);
        CFAEdge lastEdge = null;
        if (loc.getNumLeavingEdges() > 0) {
            lastEdge = loc.getLeavingEdge(0);
        }
        path.addFirst(Pair.of((Object)currentARTElement, (Object)lastEdge));
        seenElements.add(currentARTElement);
        while (!currentARTElement.getParents().isEmpty()) {
            Iterator<ARTElement> parents = currentARTElement.getParents().iterator();
            ARTElement parentElement = parents.next();
            while (!seenElements.add(parentElement) && parents.hasNext()) {
                parentElement = parents.next();
            }
            CFAEdge edge = parentElement.getEdgeToChild(currentARTElement);
            path.addFirst(Pair.of((Object)parentElement, (Object)edge));
            currentARTElement = parentElement;
        }
        return path;
    }

    public static Set<ARTElement> getCoveredBy(Set<ARTElement> elements) {
        HashSet<ARTElement> result = new HashSet<ARTElement>();
        for (ARTElement element : elements) {
            result.addAll(element.getCoveredByThis());
        }
        result.removeAll(elements);
        return result;
    }

    private static String determineColor(ARTElement currentElement) {
        PredicateAbstractElement abselem;
        String color = currentElement.isCovered() ? "green" : (currentElement.isTarget() ? "red" : ((abselem = AbstractElements.extractElementByType(currentElement, PredicateAbstractElement.class)) != null && abselem.isAbstractionElement() ? "cornflowerblue" : null));
        return color;
    }

    public static String convertARTToDot(ARTElement rootElement, Set<ARTElement> displayedElements, Set<Pair<ARTElement, ARTElement>> highlightedEdges) {
        LinkedList<ARTElement> worklist = new LinkedList<ARTElement>();
        HashSet<Integer> nodesList = new HashSet<Integer>();
        HashSet<ARTElement> processed = new HashSet<ARTElement>();
        StringBuilder sb = new StringBuilder();
        StringBuilder edges = new StringBuilder();
        sb.append("digraph ART {\n");
        sb.append("node [style=\"filled\" shape=\"box\" color=\"white\"]\n");
        worklist.add(rootElement);
        while (worklist.size() != 0) {
            ARTElement currentElement = (ARTElement)worklist.removeLast();
            if (processed.contains(currentElement) || displayedElements != null && !displayedElements.contains(currentElement)) continue;
            processed.add(currentElement);
            if (!nodesList.contains(currentElement.getElementId())) {
                String label = ARTUtils.determineLabel(currentElement);
                sb.append(currentElement.getElementId());
                sb.append(" [");
                String color = ARTUtils.determineColor(currentElement);
                if (color != null) {
                    sb.append("fillcolor=\"" + color + "\" ");
                }
                sb.append("label=\"" + label + "\" ");
                sb.append("id=\"" + currentElement.getElementId() + "\"");
                sb.append("]");
                sb.append("\n");
                nodesList.add(currentElement.getElementId());
            }
            for (ARTElement covered : currentElement.getCoveredByThis()) {
                edges.append(covered.getElementId());
                edges.append(" -> ");
                edges.append(currentElement.getElementId());
                edges.append(" [style=\"dashed\" label=\"covered by\"]\n");
            }
            for (ARTElement child : currentElement.getChildren()) {
                edges.append(currentElement.getElementId());
                edges.append(" -> ");
                edges.append(child.getElementId());
                edges.append(" [");
                boolean colored = highlightedEdges.contains(Pair.of((Object)currentElement, (Object)child));
                CFAEdge edge = currentElement.getEdgeToChild(child);
                if (colored) {
                    edges.append("color=\"red\"");
                }
                if (edge != null) {
                    if (colored) {
                        edges.append(" ");
                    }
                    edges.append("label=\"");
                    edges.append("Line ");
                    edges.append(edge.getLineNumber());
                    edges.append(": ");
                    edges.append(edge.getDescription().replaceAll("\n", " ").replace('\"', '\''));
                    edges.append("\"");
                    edges.append(" id=\"");
                    edges.append(currentElement.getElementId());
                    edges.append(" -> ");
                    edges.append(child.getElementId());
                    edges.append("\"");
                }
                edges.append("]\n");
                if (worklist.contains(child)) continue;
                worklist.add(child);
            }
        }
        sb.append((CharSequence)edges);
        sb.append("}\n");
        return sb.toString();
    }

    private static String determineLabel(ARTElement currentElement) {
        ExplicitElement explicit;
        StringBuilder builder = new StringBuilder();
        builder.append(currentElement.getElementId());
        CFANode loc = AbstractElements.extractLocation(currentElement);
        if (loc != null) {
            builder.append(" @ ");
            builder.append(loc.toString());
        }
        Iterable<AutomatonState> states = AbstractElements.extractAllElementsOfType(currentElement, AutomatonState.class);
        for (AutomatonState state : states) {
            if (state.getInternalStateName().equals("Init")) continue;
            builder.append("\\n");
            builder.append(state.getCPAName().replaceFirst("AutomatonAnalysis_", ""));
            builder.append(": ");
            builder.append(state.getInternalStateName());
        }
        PredicateAbstractElement abstraction = AbstractElements.extractElementByType(currentElement, PredicateAbstractElement.class);
        if (abstraction != null && abstraction.isAbstractionElement()) {
            builder.append("\\n");
            builder.append(abstraction.getAbstractionFormula().asFormula().toString());
        }
        if ((explicit = AbstractElements.extractElementByType(currentElement, ExplicitElement.class)) != null) {
            builder.append("\\n");
            builder.append(explicit.toCompactString());
        }
        return builder.toString();
    }

    public static Path getPathFromBranchingInformation(ARTElement root, Collection<? extends AbstractElement> art, Map<Integer, Boolean> branchingInformation) throws IllegalArgumentException {
        Preconditions.checkArgument((boolean)art.contains(root));
        Path result = new Path();
        ARTElement currentElement = root;
        while (!currentElement.isTarget()) {
            CFAEdge edge;
            ARTElement child;
            Set<ARTElement> children = currentElement.getChildren();
            switch (children.size()) {
                case 0: {
                    throw new IllegalArgumentException("ART target path terminates without reaching target element!");
                }
                case 1: {
                    child = (ARTElement)Iterables.getOnlyElement(children);
                    edge = currentElement.getEdgeToChild(child);
                    break;
                }
                case 2: {
                    CFAEdge trueEdge = null;
                    CFAEdge falseEdge = null;
                    ARTElement trueChild = null;
                    ARTElement falseChild = null;
                    for (ARTElement currentChild : children) {
                        CFAEdge currentEdge = currentElement.getEdgeToChild(currentChild);
                        if (!(currentEdge instanceof AssumeEdge)) {
                            throw new IllegalArgumentException("ART branches where there is no AssumeEdge!");
                        }
                        if (((AssumeEdge)currentEdge).getTruthAssumption()) {
                            trueEdge = currentEdge;
                            trueChild = currentChild;
                            continue;
                        }
                        falseEdge = currentEdge;
                        falseChild = currentChild;
                    }
                    if (trueEdge == null || falseEdge == null) {
                        throw new IllegalArgumentException("ART branches with non-complementary AssumeEdges!");
                    }
                    assert (trueChild != null);
                    assert (falseChild != null);
                    Boolean predValue = branchingInformation.get(currentElement.getElementId());
                    if (predValue == null) {
                        throw new IllegalArgumentException("ART branches without direction information!");
                    }
                    if (predValue.booleanValue()) {
                        edge = trueEdge;
                        child = trueChild;
                        break;
                    }
                    edge = falseEdge;
                    child = falseChild;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("ART splits with more than two branches!");
                }
            }
            if (!art.contains(child)) {
                throw new IllegalArgumentException("ART and direction information from solver disagree!");
            }
            result.add(Pair.of((Object)currentElement, (Object)edge));
            currentElement = child;
        }
        CFANode loc = AbstractElements.extractLocation(currentElement);
        CFAEdge lastEdge = null;
        if (loc.getNumLeavingEdges() > 0) {
            lastEdge = loc.getLeavingEdge(0);
        }
        result.add(Pair.of((Object)currentElement, (Object)lastEdge));
        return result;
    }

    public static Path getPathFromBranchingInformation(ARTElement root, ARTElement target, Collection<? extends AbstractElement> art, Map<Integer, Boolean> branchingInformation) throws IllegalArgumentException {
        Preconditions.checkArgument((boolean)art.contains(target));
        Preconditions.checkArgument((boolean)target.isTarget());
        Path result = ARTUtils.getPathFromBranchingInformation(root, art, branchingInformation);
        if (((Pair)result.getLast()).getFirst() != target) {
            throw new IllegalArgumentException("ART target path reached the wrong target element!");
        }
        return result;
    }
}

