/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.art;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Collections2;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionCallEdge;
import org.sosy_lab.cpachecker.core.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Refiner;
import org.sosy_lab.cpachecker.core.interfaces.WrapperCPA;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.art.ARTCPA;
import org.sosy_lab.cpachecker.cpa.art.ARTElement;
import org.sosy_lab.cpachecker.cpa.art.ARTReachedSet;
import org.sosy_lab.cpachecker.cpa.art.ARTUtils;
import org.sosy_lab.cpachecker.cpa.art.Path;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.RefinementFailedException;

public abstract class AbstractARTBasedRefiner
implements Refiner {
    private final ARTCPA mArtCpa;
    private final LogManager logger;
    private static final Function<Pair<ARTElement, CFAEdge>, String> pathToFunctionCalls = new Function<Pair<ARTElement, CFAEdge>, String>(){

        public String apply(Pair<ARTElement, CFAEdge> arg) {
            if (arg.getSecond() instanceof FunctionCallEdge) {
                FunctionCallEdge funcEdge = (FunctionCallEdge)arg.getSecond();
                return funcEdge.toString();
            }
            return null;
        }
    };

    protected AbstractARTBasedRefiner(ConfigurableProgramAnalysis pCpa) throws InvalidConfigurationException {
        if (!(pCpa instanceof WrapperCPA)) {
            throw new InvalidConfigurationException("ART CPA needed for refinement");
        }
        this.mArtCpa = ((WrapperCPA)((Object)pCpa)).retrieveWrappedCpa(ARTCPA.class);
        if (this.mArtCpa == null) {
            throw new InvalidConfigurationException("ART CPA needed for refinement");
        }
        this.logger = this.mArtCpa.getLogger();
    }

    protected final ARTCPA getArtCpa() {
        return this.mArtCpa;
    }

    @Override
    public final boolean performRefinement(ReachedSet pReached) throws CPAException, InterruptedException {
        return this.performRefinementWithInfo(pReached).isSpurious();
    }

    public final CounterexampleInfo performRefinementWithInfo(ReachedSet pReached) throws CPAException, InterruptedException {
        CounterexampleInfo counterexample;
        this.logger.log(Level.FINEST, new Object[]{"Starting ART based refinement"});
        this.mArtCpa.clearCounterexample();
        assert (AbstractARTBasedRefiner.checkART(pReached)) : "ART and reached set do not match before refinement";
        AbstractElement lastElement = pReached.getLastElement();
        assert (lastElement instanceof ARTElement) : "Element in reached set which is not an ARTElement";
        assert (((ARTElement)lastElement).isTarget()) : "Last element in reached is not a target element before refinement";
        ARTReachedSet reached = new ARTReachedSet(pReached, this.mArtCpa);
        Path path = this.computePath((ARTElement)lastElement, reached);
        if (this.logger.wouldBeLogged(Level.ALL) && path != null) {
            this.logger.log(Level.ALL, new Object[]{"Error path:\n", path});
            this.logger.log(Level.ALL, new Object[]{"Function calls on Error path:\n", Joiner.on((String)"\n ").skipNulls().join((Iterable)Collections2.transform((Collection)path, pathToFunctionCalls))});
        }
        try {
            counterexample = this.performRefinement(reached, path);
        }
        catch (RefinementFailedException e) {
            if (e.getErrorPath() == null) {
                e.setErrorPath(path);
            }
            this.mArtCpa.setCounterexample(CounterexampleInfo.feasible(e.getErrorPath(), null));
            throw e;
        }
        assert (AbstractARTBasedRefiner.checkART(pReached)) : "ART and reached set do not match after refinement";
        if (!counterexample.isSpurious()) {
            Path targetPath = counterexample.getTargetPath();
            assert (((Pair)targetPath.getFirst()).getFirst() == ((Pair)path.getFirst()).getFirst()) : "Target path from refiner does not contain root node";
            assert (((Pair)targetPath.getLast()).getFirst() == ((Pair)path.getLast()).getFirst()) : "Target path from refiner does not contain target state";
            this.mArtCpa.setCounterexample(counterexample);
        }
        this.logger.log(Level.FINEST, new Object[]{"ART based refinement finished, result is", counterexample.isSpurious()});
        return counterexample;
    }

    protected abstract CounterexampleInfo performRefinement(ARTReachedSet var1, Path var2) throws CPAException, InterruptedException;

    protected Path computePath(ARTElement pLastElement, ARTReachedSet pReached) throws InterruptedException, CPAException {
        return ARTUtils.getOnePathTo(pLastElement);
    }

    private static boolean checkART(ReachedSet pReached) {
        ArrayDeque<AbstractElement> workList = new ArrayDeque<AbstractElement>();
        HashSet<ARTElement> art = new HashSet<ARTElement>();
        workList.add(pReached.getFirstElement());
        while (!workList.isEmpty()) {
            ARTElement currentElement = (ARTElement)workList.removeFirst();
            assert (!currentElement.isDestroyed());
            for (ARTElement parent : currentElement.getParents()) {
                assert (parent.getChildren().contains(currentElement)) : "Reference from parent to child is missing in ART";
            }
            for (ARTElement child : currentElement.getChildren()) {
                assert (child.getParents().contains(currentElement)) : "Reference from child to parent is missing in ART";
            }
            if (!currentElement.isCovered()) assert (pReached.contains(currentElement) || pReached.getWaitlist().containsAll(currentElement.getParents())) : "Element in ART but not in reached set";
            if (!art.add(currentElement)) continue;
            workList.addAll(currentElement.getChildren());
        }
        assert (art.containsAll(pReached.getReached())) : "Element in reached set but not in ART";
        return true;
    }
}

