/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.art;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.cfa.ast.IASTArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.IASTExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.IASTFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.IASTIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTPointerTypeSpecifier;
import org.sosy_lab.cpachecker.cfa.ast.IASTStatement;
import org.sosy_lab.cpachecker.cfa.ast.IASTUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.IType;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.CallToReturnEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.DeclarationEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.ReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.StatementEdge;
import org.sosy_lab.cpachecker.cpa.art.ARTElement;
import org.sosy_lab.cpachecker.cpa.art.Path;

public final class ErrorPathShrinker {
    private static final Set<String> GLOBAL_VARS = new LinkedHashSet<String>();

    public Path shrinkErrorPath(Path targetPath) {
        targetPath = this.removeAllElemsAfterTarget(targetPath);
        this.findGlobalVarsInPath(targetPath);
        Iterator revIterator = targetPath.descendingIterator();
        LinkedHashSet<String> importantVars = new LinkedHashSet<String>();
        LinkedHashSet<String> importantVarsForGlobalVars = new LinkedHashSet<String>();
        Path globalVarsPath = new Path();
        Path shortErrorPath = new Path();
        Pair lastElem = (Pair)revIterator.next();
        assert (((ARTElement)lastElem.getFirst()).isTarget()) : "Last Element of ErrorPath must be a targetElement.";
        shortErrorPath.addFirst(lastElem);
        if (revIterator.hasNext()) {
            shortErrorPath.addFirst(revIterator.next());
        }
        while (revIterator.hasNext()) {
            PathHandler pathHandler = new PathHandler(shortErrorPath, revIterator, importantVars, importantVarsForGlobalVars, globalVarsPath);
            pathHandler.handlePath();
            CFAEdge lastEdge = (CFAEdge)((Pair)shortErrorPath.getFirst()).getSecond();
            if (!(lastEdge instanceof FunctionCallEdge)) continue;
            FunctionCallEdge funcEdge = (FunctionCallEdge)lastEdge;
            LinkedHashSet<String> newImportantVars = new LinkedHashSet<String>();
            this.addGlobalVarsFromSetToSet(importantVars, newImportantVars);
            importantVars = newImportantVars;
            LinkedHashSet<String> newImportantVarsForGlobalVars = new LinkedHashSet<String>();
            this.addGlobalVarsFromSetToSet(importantVarsForGlobalVars, newImportantVarsForGlobalVars);
            importantVarsForGlobalVars = newImportantVarsForGlobalVars;
            this.getImportantVarsFromFunctionCall(funcEdge, importantVars, importantVarsForGlobalVars);
        }
        return shortErrorPath;
    }

    private Path removeAllElemsAfterTarget(Path path) {
        Path targetPath = new Path();
        for (Pair it : path) {
            targetPath.add(it);
            if (!((ARTElement)it.getFirst()).isTarget()) continue;
            break;
        }
        return targetPath;
    }

    private void findGlobalVarsInPath(Path path) {
        Iterator iterator = path.iterator();
        while (iterator.hasNext()) {
            IASTDeclaration declaration;
            CFAEdge cfaEdge = (CFAEdge)((Pair)iterator.next()).getSecond();
            if (!(cfaEdge instanceof DeclarationEdge) || !(declaration = ((DeclarationEdge)cfaEdge).getDeclaration()).isGlobal()) continue;
            IType specifier = declaration.getDeclSpecifier();
            if (declaration.getName() == null || specifier instanceof IASTPointerTypeSpecifier) continue;
            GLOBAL_VARS.add(declaration.getName());
        }
    }

    private void addAllVarsInExpToSet(IASTExpression exp, Set<String> importantVars, Set<String> importantVarsForGlobalVars) {
        if (!(exp instanceof IASTLiteralExpression) && exp != null) {
            if (exp instanceof IASTIdExpression) {
                String varName = ((IASTIdExpression)exp).getName();
                importantVars.add(varName);
                if (GLOBAL_VARS.contains(varName)) {
                    importantVarsForGlobalVars.add(varName);
                }
            } else if (exp instanceof IASTCastExpression) {
                this.addAllVarsInExpToSet(((IASTCastExpression)exp).getOperand(), importantVars, importantVarsForGlobalVars);
            } else if (exp instanceof IASTUnaryExpression) {
                this.addAllVarsInExpToSet(((IASTUnaryExpression)exp).getOperand(), importantVars, importantVarsForGlobalVars);
            } else if (exp instanceof IASTBinaryExpression) {
                IASTBinaryExpression binExp = (IASTBinaryExpression)exp;
                this.addAllVarsInExpToSet(binExp.getOperand1(), importantVars, importantVarsForGlobalVars);
                this.addAllVarsInExpToSet(binExp.getOperand2(), importantVars, importantVarsForGlobalVars);
            } else if (exp instanceof IASTFieldReference) {
                String varName = exp.toASTString();
                importantVars.add(varName);
                if (GLOBAL_VARS.contains(varName)) {
                    importantVarsForGlobalVars.add(varName);
                }
            }
        }
    }

    private void addGlobalVarsFromSetToSet(Set<String> sourceSet, Set<String> targetSet) {
        for (String varName : sourceSet) {
            if (!GLOBAL_VARS.contains(varName)) continue;
            targetSet.add(varName);
        }
    }

    private void getImportantVarsFromFunctionCall(FunctionCallEdge funcEdge, Set<String> importantVars, Set<String> importantVarsForGlobalVars) {
        for (IASTExpression exp : funcEdge.getArguments()) {
            this.addAllVarsInExpToSet(exp, importantVars, importantVarsForGlobalVars);
        }
    }

    private final class PathHandler {
        private final Path shortPath;
        private final Iterator<Pair<ARTElement, CFAEdge>> reverseIterator;
        private final Set<String> importantVars;
        private final Set<String> importantVarsForGlobalVars;
        private final Path globalVarsPath;
        private Pair<ARTElement, CFAEdge> currentCFAEdgePair;

        private PathHandler(Path shortPathOut, Iterator<Pair<ARTElement, CFAEdge>> revIteratorOut, Set<String> importantVarsOut, Set<String> importantVarsForGlobalVarsOut, Path globalVarsPathOut) {
            this.shortPath = shortPathOut;
            this.reverseIterator = revIteratorOut;
            this.importantVars = importantVarsOut;
            this.importantVarsForGlobalVars = importantVarsForGlobalVarsOut;
            this.globalVarsPath = globalVarsPathOut;
        }

        private void handlePath() {
            block9: while (this.reverseIterator.hasNext()) {
                this.currentCFAEdgePair = this.reverseIterator.next();
                CFAEdge cfaEdge = (CFAEdge)this.currentCFAEdgePair.getSecond();
                switch (cfaEdge.getEdgeType()) {
                    case StatementEdge: {
                        this.handleStatement();
                        continue block9;
                    }
                    case ReturnStatementEdge: {
                        this.handleJumpStatement();
                        continue block9;
                    }
                    case DeclarationEdge: {
                        this.handleDeclaration();
                        continue block9;
                    }
                    case AssumeEdge: {
                        this.handleAssumption();
                        continue block9;
                    }
                    case BlankEdge: {
                        if (!cfaEdge.getSuccessor().isLoopStart()) continue block9;
                        this.addCurrentCFAEdgePairToShortPath();
                        continue block9;
                    }
                    case FunctionCallEdge: {
                        this.addCurrentCFAEdgePairToShortPath();
                        if (!this.globalVarsPath.isEmpty()) {
                            this.globalVarsPath.addFirst(this.currentCFAEdgePair);
                        }
                        return;
                    }
                    case FunctionReturnEdge: {
                        continue block9;
                    }
                }
                this.addCurrentCFAEdgePairToShortPath();
            }
        }

        private void handleJumpStatement() {
            LinkedHashSet<String> possibleVars = new LinkedHashSet<String>();
            ErrorPathShrinker.this.addGlobalVarsFromSetToSet(this.importantVarsForGlobalVars, possibleVars);
            IASTExpression returnExp = ((ReturnStatementEdge)this.currentCFAEdgePair.getSecond()).getExpression();
            ErrorPathShrinker.this.addAllVarsInExpToSet(returnExp, possibleVars, this.importantVarsForGlobalVars);
            Pair<ARTElement, CFAEdge> returnEdgePair = this.currentCFAEdgePair;
            Path functionGlobalVarsPath = new Path();
            Path shortFunctionPath = new Path();
            LinkedHashSet<String> possibleImportantVarsForGlobalVars = new LinkedHashSet<String>();
            ErrorPathShrinker.this.addGlobalVarsFromSetToSet(this.importantVarsForGlobalVars, possibleImportantVarsForGlobalVars);
            PathHandler recPathHandler = new PathHandler(shortFunctionPath, this.reverseIterator, possibleVars, possibleImportantVarsForGlobalVars, functionGlobalVarsPath);
            recPathHandler.handlePath();
            this.mergeResultsOfFunctionCall(shortFunctionPath, returnEdgePair, possibleVars, possibleImportantVarsForGlobalVars, functionGlobalVarsPath);
        }

        private void mergeResultsOfFunctionCall(Path shortFunctionPath, Pair<ARTElement, CFAEdge> returnEdgePair, Set<String> possibleVars, Set<String> possibleImportantVarsForGlobalVars, Path functionGlobalVarsPath) {
            CFAEdge lastEdge = (CFAEdge)((Pair)shortFunctionPath.getFirst()).getSecond();
            assert (lastEdge instanceof FunctionCallEdge);
            FunctionCallEdge funcEdge = (FunctionCallEdge)lastEdge;
            CallToReturnEdge funcSummaryEdge = funcEdge.getSummaryEdge();
            IASTFunctionCall funcExp = funcSummaryEdge.getExpression();
            if (funcExp instanceof IASTFunctionCallStatement && !functionGlobalVarsPath.isEmpty()) {
                this.getImportantVarsFromFunction(possibleImportantVarsForGlobalVars);
                ErrorPathShrinker.this.getImportantVarsFromFunctionCall(funcEdge, this.importantVars, this.importantVarsForGlobalVars);
                this.shortPath.addFirst(returnEdgePair);
                this.globalVarsPath.addFirst(returnEdgePair);
                this.shortPath.addAll(0, functionGlobalVarsPath);
                this.globalVarsPath.addAll(0, functionGlobalVarsPath);
            }
            if (funcExp instanceof IASTFunctionCallAssignmentStatement) {
                String lParam = ((IASTFunctionCallAssignmentStatement)funcExp).getLeftHandSide().toASTString();
                if (this.importantVars.contains(lParam) || !functionGlobalVarsPath.isEmpty()) {
                    this.getImportantVarsFromFunction(possibleImportantVarsForGlobalVars);
                    ErrorPathShrinker.this.getImportantVarsFromFunctionCall(funcEdge, this.importantVars, this.importantVarsForGlobalVars);
                    this.shortPath.addFirst(returnEdgePair);
                    this.globalVarsPath.addFirst(returnEdgePair);
                    this.globalVarsPath.addAll(0, functionGlobalVarsPath);
                }
                if (this.importantVars.contains(lParam)) {
                    this.shortPath.addAll(0, shortFunctionPath);
                } else if (!functionGlobalVarsPath.isEmpty()) {
                    this.shortPath.addAll(0, functionGlobalVarsPath);
                }
            }
        }

        private void getImportantVarsFromFunction(Set<String> possibleImportantVarsForGlobalVars) {
            this.importantVarsForGlobalVars.removeAll(GLOBAL_VARS);
            this.importantVars.removeAll(GLOBAL_VARS);
            ErrorPathShrinker.this.addGlobalVarsFromSetToSet(possibleImportantVarsForGlobalVars, this.importantVarsForGlobalVars);
            ErrorPathShrinker.this.addGlobalVarsFromSetToSet(possibleImportantVarsForGlobalVars, this.importantVars);
        }

        private void handleStatement() {
            IASTStatement statementExp = ((StatementEdge)this.currentCFAEdgePair.getSecond()).getStatement();
            if (statementExp instanceof IASTExpressionAssignmentStatement) {
                this.handleAssignment((IASTExpressionAssignmentStatement)statementExp);
            } else if (statementExp instanceof IASTFunctionCall) {
                this.addCurrentCFAEdgePairToShortPath();
            }
        }

        private void handleAssignment(IASTExpressionAssignmentStatement assignmentExpression) {
            IASTExpression lParam = assignmentExpression.getLeftHandSide();
            IASTExpression rightExp = assignmentExpression.getRightHandSide();
            if (lParam instanceof IASTIdExpression) {
                this.handleAssignmentToVariable(((IASTIdExpression)lParam).getName(), rightExp);
            } else if (lParam instanceof IASTUnaryExpression && ((IASTUnaryExpression)lParam).getOperator() == IASTUnaryExpression.UnaryOperator.STAR) {
                this.addCurrentCFAEdgePairToShortPath();
            } else if (lParam instanceof IASTFieldReference) {
                this.handleAssignmentToVariable(lParam.toASTString(), rightExp);
            } else if (lParam instanceof IASTArraySubscriptExpression) {
                this.addCurrentCFAEdgePairToShortPath();
            } else {
                this.addCurrentCFAEdgePairToShortPath();
            }
        }

        private void handleAssignmentToVariable(String lParam, IASTExpression rightExp) {
            if (this.importantVars.contains(lParam) || this.importantVarsForGlobalVars.contains(lParam)) {
                this.addCurrentCFAEdgePairToShortPath();
            }
            if (this.importantVars.contains(lParam)) {
                this.importantVars.remove(lParam);
                ErrorPathShrinker.this.addAllVarsInExpToSet(rightExp, this.importantVars, this.importantVarsForGlobalVars);
            }
            if (this.importantVarsForGlobalVars.contains(lParam)) {
                this.globalVarsPath.addFirst(this.currentCFAEdgePair);
                this.importantVarsForGlobalVars.remove(lParam);
                ErrorPathShrinker.this.addAllVarsInExpToSet(rightExp, this.importantVars, this.importantVarsForGlobalVars);
                ErrorPathShrinker.this.addAllVarsInExpToSet(rightExp, this.importantVarsForGlobalVars, this.importantVarsForGlobalVars);
            }
        }

        private void handleDeclaration() {
            IASTDeclaration declaration = ((DeclarationEdge)this.currentCFAEdgePair.getSecond()).getDeclaration();
            if (declaration.getName() != null) {
                String varName = declaration.getName();
                if (this.importantVars.contains(varName)) {
                    this.addCurrentCFAEdgePairToShortPath();
                    this.importantVars.remove(varName);
                }
                if (this.importantVarsForGlobalVars.contains(varName)) {
                    this.globalVarsPath.addFirst(this.currentCFAEdgePair);
                }
            }
        }

        private void handleAssumption() {
            IASTExpression assumeExp = ((AssumeEdge)this.currentCFAEdgePair.getSecond()).getExpression();
            if (!this.isSwitchStatement(assumeExp)) {
                ErrorPathShrinker.this.addAllVarsInExpToSet(assumeExp, this.importantVars, this.importantVarsForGlobalVars);
                this.addCurrentCFAEdgePairToShortPath();
                if (!this.globalVarsPath.isEmpty()) {
                    ErrorPathShrinker.this.addAllVarsInExpToSet(assumeExp, this.importantVarsForGlobalVars, this.importantVarsForGlobalVars);
                    this.globalVarsPath.addFirst(this.currentCFAEdgePair);
                }
            }
        }

        private boolean isSwitchStatement(IASTExpression assumeExp) {
            if (!this.shortPath.isEmpty()) {
                IASTExpression lastExp;
                CFAEdge lastEdge = (CFAEdge)((Pair)this.shortPath.getFirst()).getSecond();
                if (assumeExp instanceof IASTBinaryExpression && lastEdge instanceof AssumeEdge && (lastExp = ((AssumeEdge)lastEdge).getExpression()) instanceof IASTBinaryExpression) {
                    IASTExpression currentBinExpOp1 = ((IASTBinaryExpression)assumeExp).getOperand1();
                    IASTExpression lastBinExpOp1 = ((IASTBinaryExpression)lastExp).getOperand1();
                    boolean isEqualVarName = currentBinExpOp1.toASTString().equals(lastBinExpOp1.toASTString());
                    boolean isEqualOperator = ((IASTBinaryExpression)assumeExp).getOperator() == ((IASTBinaryExpression)lastExp).getOperator();
                    return isEqualVarName && isEqualOperator;
                }
            }
            return false;
        }

        private void addCurrentCFAEdgePairToShortPath() {
            this.shortPath.addFirst(this.currentCFAEdgePair);
        }
    }
}

