/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.art;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cpa.art.ARTElement;

public class Path
extends LinkedList<Pair<ARTElement, CFAEdge>> {
    private static final long serialVersionUID = -3223480082103314555L;

    @Override
    public String toString() {
        return Joiner.on((char)'\n').skipNulls().join(this.asEdgesList());
    }

    public JSONArray toJSON() {
        JSONArray path = new JSONArray();
        for (Pair pair : this) {
            JSONObject elem = new JSONObject();
            ARTElement artelem = (ARTElement)pair.getFirst();
            CFAEdge edge = (CFAEdge)pair.getSecond();
            if (edge == null) continue;
            elem.put((Object)"artelem", (Object)artelem.getElementId());
            elem.put((Object)"source", (Object)edge.getPredecessor().getNodeNumber());
            elem.put((Object)"target", (Object)edge.getSuccessor().getNodeNumber());
            elem.put((Object)"desc", (Object)edge.getDescription().replaceAll("\n", " "));
            elem.put((Object)"line", (Object)edge.getLineNumber());
            path.add((Object)elem);
        }
        return path;
    }

    public List<CFAEdge> asEdgesList() {
        return Lists.transform((List)this, (Function)Pair.getProjectionToSecond());
    }

    public ImmutableSet<ARTElement> getElementSet() {
        List elementList = Lists.transform((List)this, (Function)Pair.getProjectionToFirst());
        return ImmutableSet.copyOf((Collection)elementList);
    }
}

