/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.assumptions.genericassumptions;

import java.util.List;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.cfa.ast.IASTAssignment;
import org.sosy_lab.cpachecker.cfa.ast.IASTBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.IASTSimpleDeclSpecifier;
import org.sosy_lab.cpachecker.cfa.ast.IASTStatement;
import org.sosy_lab.cpachecker.cfa.ast.IASTUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.IType;
import org.sosy_lab.cpachecker.cfa.ast.NumericTypes;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionDefinitionNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.ReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.StatementEdge;
import org.sosy_lab.cpachecker.cpa.assumptions.genericassumptions.GenericAssumptionBuilder;

public class ArithmeticOverflowAssumptionBuilder
implements GenericAssumptionBuilder {
    private static Pair<IASTIntegerLiteralExpression, IASTIntegerLiteralExpression> boundsForType(IType typ) {
        if (typ instanceof IASTSimpleDeclSpecifier) {
            IASTSimpleDeclSpecifier btyp = (IASTSimpleDeclSpecifier)typ;
            switch (btyp.getType()) {
                case INT: {
                    return Pair.of((Object)NumericTypes.INT_MIN, (Object)NumericTypes.INT_MAX);
                }
            }
        }
        return Pair.of(null, null);
    }

    private static IASTExpression conjunctPredicateForArithmeticExpression(IASTExpression exp, IASTExpression result) {
        return ArithmeticOverflowAssumptionBuilder.conjunctPredicateForArithmeticExpression(exp.getExpressionType(), exp, result);
    }

    private static IASTExpression conjunctPredicateForArithmeticExpression(IType typ, IASTExpression exp, IASTExpression result) {
        IASTBinaryExpression secondExp;
        Pair<IASTIntegerLiteralExpression, IASTIntegerLiteralExpression> bounds = ArithmeticOverflowAssumptionBuilder.boundsForType(typ);
        if (bounds.getFirst() != null) {
            secondExp = new IASTBinaryExpression(null, null, exp, (IASTExpression)bounds.getFirst(), IASTBinaryExpression.BinaryOperator.GREATER_EQUAL);
            result = new IASTBinaryExpression(null, null, result, secondExp, IASTBinaryExpression.BinaryOperator.LOGICAL_AND);
        }
        if (bounds.getSecond() != null) {
            secondExp = new IASTBinaryExpression(null, null, exp, (IASTExpression)bounds.getSecond(), IASTBinaryExpression.BinaryOperator.LESS_EQUAL);
            result = new IASTBinaryExpression(null, null, result, secondExp, IASTBinaryExpression.BinaryOperator.LOGICAL_AND);
        }
        return result;
    }

    private static IASTExpression visit(IASTExpression pExpression, IASTExpression result) {
        if (pExpression instanceof IASTIdExpression) {
            result = ArithmeticOverflowAssumptionBuilder.conjunctPredicateForArithmeticExpression(pExpression, result);
        } else if (pExpression instanceof IASTBinaryExpression) {
            IASTBinaryExpression binexp = (IASTBinaryExpression)pExpression;
            IASTExpression op1 = binexp.getOperand1();
            if (op1 instanceof IASTIdExpression) {
                result = ArithmeticOverflowAssumptionBuilder.conjunctPredicateForArithmeticExpression(op1, result);
            }
        } else if (pExpression instanceof IASTUnaryExpression) {
            IASTUnaryExpression unexp = (IASTUnaryExpression)pExpression;
            IASTExpression op1 = unexp.getOperand();
            if (op1 instanceof IASTIdExpression) {
                result = ArithmeticOverflowAssumptionBuilder.conjunctPredicateForArithmeticExpression(op1, result);
            }
        } else if (pExpression instanceof IASTCastExpression) {
            IASTCastExpression castexp = (IASTCastExpression)pExpression;
            IType toType = castexp.getExpressionType();
            result = ArithmeticOverflowAssumptionBuilder.conjunctPredicateForArithmeticExpression(toType, castexp.getOperand(), result);
        }
        return result;
    }

    @Override
    public IASTExpression assumptionsForEdge(CFAEdge pEdge) {
        IASTExpression result = NumericTypes.TRUE;
        switch (pEdge.getEdgeType()) {
            case AssumeEdge: {
                AssumeEdge assumeEdge = (AssumeEdge)pEdge;
                result = ArithmeticOverflowAssumptionBuilder.visit(assumeEdge.getExpression(), result);
                break;
            }
            case FunctionCallEdge: {
                FunctionCallEdge fcallEdge = (FunctionCallEdge)pEdge;
                if (fcallEdge.getArguments().isEmpty()) break;
                FunctionDefinitionNode fdefnode = fcallEdge.getSuccessor();
                List<IASTParameterDeclaration> formalParams = fdefnode.getFunctionParameters();
                for (IASTParameterDeclaration paramdecl : formalParams) {
                    String name = paramdecl.getName();
                    IType type = paramdecl.getDeclSpecifier();
                    IASTIdExpression exp = new IASTIdExpression(paramdecl.getFileLocation(), type, name, paramdecl);
                    result = ArithmeticOverflowAssumptionBuilder.visit(exp, result);
                }
                break;
            }
            case StatementEdge: {
                StatementEdge stmtEdge = (StatementEdge)pEdge;
                IASTStatement stmt = stmtEdge.getStatement();
                if (!(stmt instanceof IASTAssignment)) break;
                result = ArithmeticOverflowAssumptionBuilder.visit(((IASTAssignment)((Object)stmt)).getLeftHandSide(), result);
                break;
            }
            case ReturnStatementEdge: {
                ReturnStatementEdge returnEdge = (ReturnStatementEdge)pEdge;
                if (returnEdge.getExpression() == null) break;
                result = ArithmeticOverflowAssumptionBuilder.visit(returnEdge.getExpression(), result);
            }
        }
        return result;
    }
}

