/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.assumptions.genericassumptions;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.ast.IASTBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTExpression;
import org.sosy_lab.cpachecker.cfa.ast.NumericTypes;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.assumptions.genericassumptions.ArithmeticOverflowAssumptionBuilder;
import org.sosy_lab.cpachecker.cpa.assumptions.genericassumptions.GenericAssumptionBuilder;
import org.sosy_lab.cpachecker.cpa.assumptions.genericassumptions.GenericAssumptionsElement;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;

public class GenericAssumptionsTransferRelation
implements TransferRelation {
    private final List<GenericAssumptionBuilder> assumptionBuilders = ImmutableList.of((Object)new ArithmeticOverflowAssumptionBuilder());

    @Override
    public Collection<? extends AbstractElement> getAbstractSuccessors(AbstractElement el, Precision p, CFAEdge edge) throws CPATransferException {
        IASTExpression allAssumptions = null;
        for (GenericAssumptionBuilder b : this.assumptionBuilders) {
            IASTExpression assumption = b.assumptionsForEdge(edge);
            if (assumption == null) continue;
            if (allAssumptions == null) {
                allAssumptions = assumption;
                continue;
            }
            allAssumptions = new IASTBinaryExpression(null, null, allAssumptions, assumption, IASTBinaryExpression.BinaryOperator.LOGICAL_AND);
        }
        if (allAssumptions == null) {
            allAssumptions = NumericTypes.TRUE;
        }
        return Collections.singleton(new GenericAssumptionsElement(allAssumptions));
    }

    @Override
    public Collection<? extends AbstractElement> strengthen(AbstractElement el, List<AbstractElement> otherElements, CFAEdge edge, Precision p) throws CPATransferException {
        return null;
    }
}

