/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.assumptions.storage;

import com.google.common.base.Preconditions;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;

public class AssumptionStorageElement
implements AbstractElement {
    private final Formula assumption;
    private final Formula stopFormula;

    public AssumptionStorageElement(Formula pAssumption, Formula pStopFormula) {
        this.assumption = (Formula)Preconditions.checkNotNull((Object)pAssumption);
        this.stopFormula = (Formula)Preconditions.checkNotNull((Object)pStopFormula);
        assert (!this.assumption.isFalse());
    }

    public Formula getAssumption() {
        return this.assumption;
    }

    public Formula getStopFormula() {
        return this.stopFormula;
    }

    public String toString() {
        return (this.stopFormula.isTrue() ? "" : "<STOP> ") + "assume: (" + this.assumption + " & " + this.stopFormula + ")";
    }

    public boolean isStop() {
        return !this.stopFormula.isTrue();
    }

    public boolean equals(Object other) {
        if (other instanceof AssumptionStorageElement) {
            AssumptionStorageElement otherElement = (AssumptionStorageElement)other;
            return this.assumption.equals(otherElement.assumption) && this.stopFormula.equals(otherElement.stopFormula);
        }
        return false;
    }

    public int hashCode() {
        return this.assumption.hashCode() + 17 * this.stopFormula.hashCode();
    }
}

