/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.assumptions.storage;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.ast.IASTExpression;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.conditions.AssumptionReportingElement;
import org.sosy_lab.cpachecker.core.interfaces.conditions.AvoidanceReportingElement;
import org.sosy_lab.cpachecker.cpa.assumptions.storage.AssumptionStorageElement;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCCodeException;
import org.sosy_lab.cpachecker.util.AbstractElements;
import org.sosy_lab.cpachecker.util.predicates.CtoFormulaConverter;
import org.sosy_lab.cpachecker.util.predicates.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaManager;

public class AssumptionStorageTransferRelation
implements TransferRelation {
    private final CtoFormulaConverter converter;
    private final FormulaManager formulaManager;
    private final Collection<AbstractElement> topElementSet;

    public AssumptionStorageTransferRelation(CtoFormulaConverter pConverter, FormulaManager pFormulaManager, AbstractElement pTopElement) {
        this.converter = pConverter;
        this.formulaManager = pFormulaManager;
        this.topElementSet = Collections.singleton(pTopElement);
    }

    @Override
    public Collection<? extends AbstractElement> getAbstractSuccessors(AbstractElement pElement, Precision pPrecision, CFAEdge pCfaEdge) {
        AssumptionStorageElement element = (AssumptionStorageElement)pElement;
        if (element.isStop()) {
            return Collections.emptySet();
        }
        return this.topElementSet;
    }

    @Override
    public Collection<? extends AbstractElement> strengthen(AbstractElement el, List<AbstractElement> others, CFAEdge edge, Precision p) throws UnrecognizedCCodeException {
        AssumptionStorageElement asmptStorageElem = (AssumptionStorageElement)el;
        assert (asmptStorageElem.getAssumption().isTrue());
        assert (asmptStorageElem.getStopFormula().isTrue());
        String function = edge.getSuccessor() != null ? edge.getSuccessor().getFunctionName() : null;
        Formula assumption = this.formulaManager.makeTrue();
        Formula stopFormula = this.formulaManager.makeFalse();
        boolean stop = false;
        for (AbstractElement element : AbstractElements.asIterable(others)) {
            AvoidanceReportingElement e;
            if (element instanceof AssumptionReportingElement) {
                IASTExpression inv = ((AssumptionReportingElement)((Object)element)).getAssumption();
                Formula invFormula = this.converter.makePredicate(inv, edge, function, SSAMap.emptySSAMap().builder());
                assumption = this.formulaManager.makeAnd(assumption, this.formulaManager.uninstantiate(invFormula));
            }
            if (!(element instanceof AvoidanceReportingElement) || !(e = (AvoidanceReportingElement)element).mustDumpAssumptionForAvoidance()) continue;
            stopFormula = this.formulaManager.makeOr(stopFormula, e.getReasonFormula(this.formulaManager));
            stop = true;
        }
        Preconditions.checkState((!stopFormula.isTrue() ? 1 : 0) != 0);
        if (!stop) {
            stopFormula = this.formulaManager.makeTrue();
        }
        if (assumption.isTrue() && stopFormula.isTrue()) {
            return null;
        }
        return Collections.singleton(new AssumptionStorageElement(assumption, stopFormula));
    }
}

