/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.automaton;

import com.google.common.collect.Maps;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonInternalState;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonTransition;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonVariable;
import org.sosy_lab.cpachecker.cpa.automaton.InvalidAutomatonException;

public class Automaton {
    private final String name;
    private final Map<String, AutomatonVariable> initVars;
    private final List<AutomatonInternalState> states;
    private final AutomatonInternalState initState;

    public Automaton(String pName, Map<String, AutomatonVariable> pVars, List<AutomatonInternalState> pStates, String pInit) throws InvalidAutomatonException {
        this.name = pName;
        this.initVars = pVars;
        this.states = pStates;
        HashMap statesMap = Maps.newHashMapWithExpectedSize((int)pStates.size());
        for (AutomatonInternalState s : pStates) {
            if (statesMap.put(s.getName(), s) == null) continue;
            throw new InvalidAutomatonException("State " + s.getName() + " exists twice in automaton " + pName);
        }
        this.initState = (AutomatonInternalState)statesMap.get(pInit);
        if (this.initState == null) {
            throw new InvalidAutomatonException("Inital state " + pInit + " not found in automaton " + pName);
        }
        for (AutomatonInternalState s : pStates) {
            s.setFollowStates(statesMap);
        }
    }

    public List<AutomatonInternalState> getStates() {
        return this.states;
    }

    public String getName() {
        return this.name;
    }

    AutomatonInternalState getInitialState() {
        return this.initState;
    }

    public int getNumberOfStates() {
        return this.states.size();
    }

    void writeDotFile(PrintStream pOut) {
        pOut.println("digraph " + this.name + "{");
        boolean errorState = false;
        boolean bottomState = false;
        for (AutomatonInternalState s : this.states) {
            String color = this.initState.equals(s) ? "green" : "black";
            pOut.println(Automaton.formatState(s, color));
            for (AutomatonTransition t : s.getTransitions()) {
                pOut.println(Automaton.formatTransition(s, t));
                errorState = errorState || t.getFollowState().equals(AutomatonInternalState.ERROR);
                bottomState = bottomState || t.getFollowState().equals(AutomatonInternalState.BOTTOM);
            }
        }
        if (errorState) {
            pOut.println(Automaton.formatState(AutomatonInternalState.ERROR, "red"));
        }
        if (bottomState) {
            pOut.println(Automaton.formatState(AutomatonInternalState.BOTTOM, "red"));
        }
        pOut.println("}");
    }

    private static String formatState(AutomatonInternalState s, String color) {
        String name = s.getName().replace("_predefinedState_", "");
        return String.format("%d [shape=\"circle\" color=\"%s\" label=\"%s\"]", s.getStateId(), color, name);
    }

    private static String formatTransition(AutomatonInternalState sourceState, AutomatonTransition t) {
        return String.format("%d -> %d [label=\"\"]", sourceState.getStateId(), t.getFollowState().getStateId());
    }

    public Map<String, AutomatonVariable> getInitialVariables() {
        return this.initVars;
    }

    public void assertObserverAutomaton() throws InvalidConfigurationException {
        for (AutomatonInternalState s : this.states) {
            for (AutomatonTransition t : s.getTransitions()) {
                if (t.meetsObserverRequirements()) continue;
                throw new InvalidConfigurationException("The transition " + t + " in state \"" + s + "\" is not valid for an ObserverAutomaton.");
            }
        }
    }
}

