/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.automaton;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.cfa.CParser;
import org.sosy_lab.cpachecker.cfa.ast.IASTArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTAssignment;
import org.sosy_lab.cpachecker.cfa.ast.IASTBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.IASTExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.IASTFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.IASTFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.IASTIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTNode;
import org.sosy_lab.cpachecker.cfa.ast.IASTRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.IASTStatement;
import org.sosy_lab.cpachecker.cfa.ast.IASTStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTTypeIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.IType;
import org.sosy_lab.cpachecker.cfa.ast.RightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.ast.StatementVisitor;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonExpressionArguments;
import org.sosy_lab.cpachecker.cpa.automaton.InvalidAutomatonException;
import org.sosy_lab.cpachecker.exceptions.ParserException;

class AutomatonASTComparator {
    static CParser parser = null;
    private static final String JOKER_EXPR = "CPAChecker_AutomatonAnalysis_JokerExpression";
    private static final String NUMBERED_JOKER_EXPR = "CPAChecker_AutomatonAnalysis_JokerExpression_Num";
    private static final Pattern NUMBERED_JOKER_PATTERN = Pattern.compile("\\$\\d+");

    AutomatonASTComparator() {
    }

    static ASTMatcher generatePatternAST(String pPattern) throws InvalidAutomatonException {
        String tmp = AutomatonASTComparator.addFunctionDeclaration(AutomatonASTComparator.replaceJokersInPattern(pPattern));
        return AutomatonASTComparator.parse(tmp).accept(ASTMatcherGenerator.INSTANCE);
    }

    static IASTStatement generateSourceAST(String pSource) throws InvalidAutomatonException {
        String tmp = AutomatonASTComparator.addFunctionDeclaration(pSource);
        return AutomatonASTComparator.parse(tmp);
    }

    private static String replaceJokersInPattern(String pPattern) {
        String tmp = pPattern.replaceAll("\\$\\?", " CPAChecker_AutomatonAnalysis_JokerExpression ");
        Matcher matcher = NUMBERED_JOKER_PATTERN.matcher(tmp);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(result, "");
            String key = tmp.substring(matcher.start() + 1, matcher.end());
            try {
                int varKey = Integer.parseInt(key);
                result.append(" CPAChecker_AutomatonAnalysis_JokerExpression_Num" + varKey + " ");
            }
            catch (NumberFormatException e) {
                result.append(matcher.group());
            }
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private static String addFunctionDeclaration(String pBody) {
        if (pBody.trim().endsWith(";")) {
            return "void test() { " + pBody + "}";
        }
        return "void test() { " + pBody + ";}";
    }

    private static IASTStatement parse(String code) throws InvalidAutomatonException {
        Preconditions.checkState((parser != null ? 1 : 0) != 0);
        try {
            IASTNode statement = parser.parseSingleStatement(code);
            if (!(statement instanceof IASTStatement)) {
                throw new InvalidAutomatonException("Not a valid statement: " + statement.toASTString());
            }
            return (IASTStatement)statement;
        }
        catch (ParserException e) {
            throw new InvalidAutomatonException("Error during parsing C code \"" + code + "\": " + e.getMessage());
        }
    }

    private static class FunctionCallExpressionMatcher
    extends FunctionCallWildcardExpressionMatcher {
        private final List<ASTMatcher> parameterPatterns;

        protected FunctionCallExpressionMatcher(IASTFunctionCallExpression pPattern, ASTMatcher pFunctionNameExpression, List<ASTMatcher> pParameterPatterns) {
            super(pPattern, pFunctionNameExpression);
            this.parameterPatterns = pParameterPatterns;
        }

        @Override
        protected boolean matches2(IASTFunctionCallExpression pSource, AutomatonExpressionArguments pArg) {
            if (!super.matches2(pSource, pArg)) {
                return false;
            }
            if (this.parameterPatterns.size() != pSource.getParameterExpressions().size()) {
                return false;
            }
            for (Pair parameters : Pair.zipList(this.parameterPatterns, pSource.getParameterExpressions())) {
                if (((ASTMatcher)parameters.getFirst()).matches((IASTNode)parameters.getSecond(), pArg)) continue;
                return false;
            }
            return true;
        }

        @Override
        protected IASTExpression getOperandFrom(IASTFunctionCallExpression pSource) {
            return pSource.getFunctionNameExpression();
        }
    }

    private static class FunctionCallWildcardExpressionMatcher
    extends OneOperandExpressionMatcher<IASTFunctionCallExpression, Void> {
        protected FunctionCallWildcardExpressionMatcher(IASTFunctionCallExpression pPattern, ASTMatcher pFunctionNameExpression) {
            super(IASTFunctionCallExpression.class, pPattern, pFunctionNameExpression);
        }

        protected IASTExpression getOperandFrom(IASTFunctionCallExpression pSource) {
            return pSource.getFunctionNameExpression();
        }
    }

    private static class TypeIdExpressionMatcher
    extends ExpressionWithFieldMatcher<IASTTypeIdExpression, IType> {
        private final IASTTypeIdExpression.TypeIdOperator operator;

        public TypeIdExpressionMatcher(IASTTypeIdExpression pPattern) {
            super(IASTTypeIdExpression.class, pPattern);
            this.operator = pPattern.getOperator();
        }

        @Override
        protected boolean matches2(IASTTypeIdExpression pSource, AutomatonExpressionArguments pArg) {
            return Objects.equal((Object)((Object)this.operator), (Object)((Object)pSource.getOperator())) && super.matches2(pSource, pArg);
        }

        @Override
        protected IType getFieldValueFrom(IASTTypeIdExpression pSource) {
            return pSource.getType();
        }
    }

    private static class UnaryExpressionMatcher
    extends OneOperandExpressionMatcher<IASTUnaryExpression, IASTUnaryExpression.UnaryOperator> {
        public UnaryExpressionMatcher(IASTUnaryExpression pPattern, ASTMatcher pOperand) {
            super(IASTUnaryExpression.class, pPattern, pOperand);
        }

        protected IASTExpression getOperandFrom(IASTUnaryExpression pSource) {
            return pSource.getOperand();
        }

        @Override
        protected IASTUnaryExpression.UnaryOperator getFieldValueFrom(IASTUnaryExpression pSource) {
            return pSource.getOperator();
        }
    }

    private static class IASTIdExpressionMatcher
    extends ExpressionWithFieldMatcher<IASTIdExpression, String> {
        public IASTIdExpressionMatcher(IASTIdExpression pPattern) {
            super(IASTIdExpression.class, pPattern);
        }

        @Override
        protected String getFieldValueFrom(IASTIdExpression pSource) {
            return pSource.getName();
        }
    }

    private static class FieldReferenceMatcher
    extends OneOperandExpressionMatcher<IASTFieldReference, String> {
        public FieldReferenceMatcher(IASTFieldReference pPattern, ASTMatcher pOperand) {
            super(IASTFieldReference.class, pPattern, pOperand);
        }

        protected IASTExpression getOperandFrom(IASTFieldReference pSource) {
            return pSource.getFieldOwner();
        }

        @Override
        protected String getFieldValueFrom(IASTFieldReference pSource) {
            return pSource.getFieldName();
        }
    }

    private static class CastExpressionMatcher
    extends OneOperandExpressionMatcher<IASTCastExpression, IType> {
        public CastExpressionMatcher(IASTCastExpression pPattern, ASTMatcher pOperand) {
            super(IASTCastExpression.class, pPattern, pOperand);
        }

        protected IASTExpression getOperandFrom(IASTCastExpression pSource) {
            return pSource.getOperand();
        }

        @Override
        protected IType getFieldValueFrom(IASTCastExpression pSource) {
            return pSource.getType();
        }
    }

    private static class BinaryExpressionMatcher
    extends TwoOperandExpressionMatcher<IASTBinaryExpression, IASTBinaryExpression.BinaryOperator> {
        public BinaryExpressionMatcher(IASTBinaryExpression pPattern, ASTMatcher pOperand1, ASTMatcher pOperand2) {
            super(IASTBinaryExpression.class, pPattern, pOperand1, pOperand2);
        }

        protected IASTExpression getOperand1From(IASTBinaryExpression pSource) {
            return pSource.getOperand1();
        }

        protected IASTExpression getOperand2From(IASTBinaryExpression pSource) {
            return pSource.getOperand2();
        }

        @Override
        protected IASTBinaryExpression.BinaryOperator getFieldValueFrom(IASTBinaryExpression pSource) {
            return pSource.getOperator();
        }
    }

    private static class ArraySubscriptExpressionMatcher
    extends TwoOperandExpressionMatcher<IASTArraySubscriptExpression, Void> {
        public ArraySubscriptExpressionMatcher(IASTArraySubscriptExpression pPattern, ASTMatcher pOperand1, ASTMatcher pOperand2) {
            super(IASTArraySubscriptExpression.class, pPattern, pOperand1, pOperand2);
        }

        protected IASTExpression getOperand1From(IASTArraySubscriptExpression pSource) {
            return pSource.getArrayExpression();
        }

        protected IASTExpression getOperand2From(IASTArraySubscriptExpression pSource) {
            return pSource.getSubscriptExpression();
        }
    }

    private static class NumberedJokerMatcher
    implements ASTMatcher {
        private final int number;

        public NumberedJokerMatcher(int pNumber) {
            this.number = pNumber;
        }

        @Override
        public boolean matches(IASTNode pSource, AutomatonExpressionArguments pArgs) {
            String value = pSource.toASTString();
            pArgs.putTransitionVariable(this.number, value);
            return true;
        }

        public String toString() {
            return "$" + this.number;
        }
    }

    private static enum JokerMatcher implements ASTMatcher
    {
        INSTANCE;


        @Override
        public boolean matches(IASTNode pSource, AutomatonExpressionArguments pArgs) {
            return true;
        }

        public String toString() {
            return "$?";
        }
    }

    private static abstract class TwoOperandExpressionMatcher<T extends IASTNode, F>
    extends ExpressionWithFieldMatcher<T, F> {
        private final ASTMatcher operand1;
        private final ASTMatcher operand2;

        protected TwoOperandExpressionMatcher(Class<T> pCls, T pPattern, ASTMatcher pOperand1, ASTMatcher pOperand2) {
            super(pCls, pPattern);
            this.operand1 = pOperand1;
            this.operand2 = pOperand2;
        }

        @Override
        public final boolean matches2(T pSource, AutomatonExpressionArguments pArgs) {
            return super.matches2(pSource, pArgs) && this.operand1.matches(this.getOperand1From(pSource), pArgs) && this.operand2.matches(this.getOperand2From(pSource), pArgs);
        }

        protected abstract IASTRightHandSide getOperand1From(T var1);

        protected abstract IASTRightHandSide getOperand2From(T var1);
    }

    private static abstract class OneOperandExpressionMatcher<T extends IASTNode, F>
    extends ExpressionWithFieldMatcher<T, F> {
        private final ASTMatcher operand;

        protected OneOperandExpressionMatcher(Class<T> pCls, T pPattern, ASTMatcher pOperand) {
            super(pCls, pPattern);
            this.operand = pOperand;
        }

        @Override
        protected boolean matches2(T pSource, AutomatonExpressionArguments pArgs) {
            return super.matches2(pSource, pArgs) && this.operand.matches(this.getOperandFrom(pSource), pArgs);
        }

        protected abstract IASTRightHandSide getOperandFrom(T var1);
    }

    private static abstract class ExpressionWithFieldMatcher<T extends IASTNode, F>
    extends CheckedExpressionMatcher<T> {
        private final F field;

        protected ExpressionWithFieldMatcher(Class<T> pCls, T pPattern) {
            super(pCls, pPattern);
            this.field = this.getFieldValueFrom(pPattern);
        }

        @Override
        protected boolean matches2(T pSource, AutomatonExpressionArguments pArg) {
            return Objects.equal(this.field, this.getFieldValueFrom(pSource));
        }

        protected F getFieldValueFrom(T pSource) {
            return null;
        }
    }

    private static abstract class CheckedExpressionMatcher<T extends IASTNode>
    implements ASTMatcher {
        private final Class<T> cls;
        private final String rawSignature;

        protected CheckedExpressionMatcher(Class<T> pCls, T pPattern) {
            assert (pCls.isInstance(pPattern));
            this.cls = pCls;
            this.rawSignature = ((IASTNode)pPattern).toASTString();
        }

        @Override
        public final boolean matches(IASTNode pSource, AutomatonExpressionArguments pArgs) {
            if (this.cls.isInstance(pSource)) {
                return this.matches2((IASTNode)this.cls.cast(pSource), pArgs);
            }
            return false;
        }

        protected abstract boolean matches2(T var1, AutomatonExpressionArguments var2);

        public String toString() {
            return this.rawSignature;
        }
    }

    private static enum ASTMatcherGenerator implements RightHandSideVisitor<ASTMatcher, RuntimeException>,
    StatementVisitor<ASTMatcher, RuntimeException>
    {
        INSTANCE;


        @Override
        public ASTMatcher visit(IASTIdExpression exp) {
            String name = exp.getName();
            if (name.equals(AutomatonASTComparator.JOKER_EXPR)) {
                return JokerMatcher.INSTANCE;
            }
            if (name.startsWith(AutomatonASTComparator.NUMBERED_JOKER_EXPR)) {
                String s = name.substring(AutomatonASTComparator.NUMBERED_JOKER_EXPR.length());
                int i = Integer.parseInt(s);
                return new NumberedJokerMatcher(i);
            }
            return new IASTIdExpressionMatcher(exp);
        }

        @Override
        public ASTMatcher visit(IASTArraySubscriptExpression exp) {
            return new ArraySubscriptExpressionMatcher(exp, ((IASTRightHandSide)exp.getArrayExpression()).accept(this), ((IASTRightHandSide)exp.getSubscriptExpression()).accept(this));
        }

        @Override
        public ASTMatcher visit(IASTBinaryExpression exp) {
            return new BinaryExpressionMatcher(exp, ((IASTRightHandSide)exp.getOperand1()).accept(this), ((IASTRightHandSide)exp.getOperand2()).accept(this));
        }

        @Override
        public ASTMatcher visit(IASTCastExpression exp) {
            return new CastExpressionMatcher(exp, ((IASTRightHandSide)exp.getOperand()).accept(this));
        }

        @Override
        public ASTMatcher visit(IASTFieldReference exp) {
            return new FieldReferenceMatcher(exp, ((IASTRightHandSide)exp.getFieldOwner()).accept(this));
        }

        @Override
        public ASTMatcher visit(IASTCharLiteralExpression exp) {
            return new ExpressionWithFieldMatcher<IASTCharLiteralExpression, Character>(IASTCharLiteralExpression.class, exp){

                @Override
                protected Character getFieldValueFrom(IASTCharLiteralExpression pSource) {
                    return Character.valueOf(pSource.getCharacter());
                }
            };
        }

        @Override
        public ASTMatcher visit(IASTFloatLiteralExpression exp) {
            return new ExpressionWithFieldMatcher<IASTFloatLiteralExpression, BigDecimal>(IASTFloatLiteralExpression.class, exp){

                @Override
                protected BigDecimal getFieldValueFrom(IASTFloatLiteralExpression pSource) {
                    return pSource.getValue();
                }
            };
        }

        @Override
        public ASTMatcher visit(IASTIntegerLiteralExpression exp) {
            return new ExpressionWithFieldMatcher<IASTIntegerLiteralExpression, BigInteger>(IASTIntegerLiteralExpression.class, exp){

                @Override
                protected BigInteger getFieldValueFrom(IASTIntegerLiteralExpression pSource) {
                    return pSource.getValue();
                }
            };
        }

        @Override
        public ASTMatcher visit(IASTStringLiteralExpression exp) {
            return new ExpressionWithFieldMatcher<IASTStringLiteralExpression, String>(IASTStringLiteralExpression.class, exp){

                @Override
                protected String getFieldValueFrom(IASTStringLiteralExpression pSource) {
                    return pSource.getValue();
                }
            };
        }

        @Override
        public ASTMatcher visit(IASTTypeIdExpression exp) {
            return new TypeIdExpressionMatcher(exp);
        }

        @Override
        public ASTMatcher visit(IASTUnaryExpression exp) {
            return new UnaryExpressionMatcher(exp, ((IASTRightHandSide)exp.getOperand()).accept(this));
        }

        @Override
        public ASTMatcher visit(IASTFunctionCallExpression exp) {
            ArrayList<ASTMatcher> parameterPatterns = new ArrayList<ASTMatcher>(exp.getParameterExpressions().size());
            for (IASTExpression parameter : exp.getParameterExpressions()) {
                parameterPatterns.add(((IASTRightHandSide)parameter).accept(this));
            }
            ASTMatcher functionNamePattern = ((IASTRightHandSide)exp.getFunctionNameExpression()).accept(this);
            if (parameterPatterns.size() == 1 && parameterPatterns.get(0) == JokerMatcher.INSTANCE) {
                return new FunctionCallWildcardExpressionMatcher(exp, functionNamePattern);
            }
            return new FunctionCallExpressionMatcher(exp, functionNamePattern, parameterPatterns);
        }

        @Override
        public ASTMatcher visit(IASTExpressionStatement stmt) {
            return new OneOperandExpressionMatcher<IASTExpressionStatement, Void>(IASTExpressionStatement.class, stmt, ((IASTRightHandSide)stmt.getExpression()).accept(this)){

                protected IASTExpression getOperandFrom(IASTExpressionStatement pSource) {
                    return pSource.getExpression();
                }
            };
        }

        private ASTMatcher visit(final IASTAssignment stmt) {
            final ASTMatcher leftHandSide = ((IASTRightHandSide)stmt.getLeftHandSide()).accept(this);
            final ASTMatcher rightHandSide = stmt.getRightHandSide().accept(this);
            if (rightHandSide == JokerMatcher.INSTANCE) {
                return new ASTMatcher(){

                    @Override
                    public boolean matches(IASTNode pSource, AutomatonExpressionArguments pArgs) {
                        if (pSource instanceof IASTAssignment) {
                            IASTAssignment source = (IASTAssignment)((Object)pSource);
                            return leftHandSide.matches(source.getLeftHandSide(), pArgs);
                        }
                        return false;
                    }

                    public String toString() {
                        return stmt.asStatement().toASTString();
                    }
                };
            }
            return new ASTMatcher(){

                @Override
                public boolean matches(IASTNode pSource, AutomatonExpressionArguments pArgs) {
                    if (pSource instanceof IASTAssignment) {
                        IASTAssignment source = (IASTAssignment)((Object)pSource);
                        return leftHandSide.matches(source.getLeftHandSide(), pArgs) && rightHandSide.matches(source.getRightHandSide(), pArgs);
                    }
                    return false;
                }

                public String toString() {
                    return stmt.asStatement().toASTString();
                }
            };
        }

        @Override
        public ASTMatcher visit(IASTExpressionAssignmentStatement stmt) {
            return this.visit((IASTAssignment)stmt);
        }

        @Override
        public ASTMatcher visit(IASTFunctionCallAssignmentStatement stmt) {
            return this.visit((IASTAssignment)stmt);
        }

        @Override
        public ASTMatcher visit(IASTFunctionCallStatement stmt) {
            return new OneOperandExpressionMatcher<IASTFunctionCallStatement, Void>(IASTFunctionCallStatement.class, stmt, stmt.getFunctionCallExpression().accept(this)){

                @Override
                protected IASTRightHandSide getOperandFrom(IASTFunctionCallStatement pSource) {
                    return pSource.getFunctionCallExpression();
                }
            };
        }
    }

    static interface ASTMatcher {
        public boolean matches(IASTNode var1, AutomatonExpressionArguments var2);
    }
}

