/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.automaton;

import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.AbstractQueryableElement;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonExpression;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonExpressionArguments;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonIntExpr;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonVariable;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.InvalidQueryException;

abstract class AutomatonAction {
    private static AutomatonExpression.ResultValue<String> defaultResultValue = new AutomatonExpression.ResultValue<String>("");

    private AutomatonAction() {
    }

    abstract AutomatonExpression.ResultValue<? extends Object> eval(AutomatonExpressionArguments var1) throws CPATransferException;

    boolean canExecuteOn(AutomatonExpressionArguments pArgs) throws CPATransferException {
        return true;
    }

    static class CPAModification
    extends AutomatonAction {
        private final String cpaName;
        private final String modificationString;

        public CPAModification(String pCPAName, String pModification) {
            this.cpaName = pCPAName;
            this.modificationString = pModification;
        }

        @Override
        boolean canExecuteOn(AutomatonExpressionArguments pArgs) {
            if (pArgs.replaceVariables(this.modificationString) == null) {
                return false;
            }
            for (AbstractElement ae : pArgs.getAbstractElements()) {
                AbstractQueryableElement aqe;
                if (!(ae instanceof AbstractQueryableElement) || !(aqe = (AbstractQueryableElement)ae).getCPAName().equals(this.cpaName)) continue;
                return true;
            }
            return false;
        }

        @Override
        AutomatonExpression.ResultValue<? extends Object> eval(AutomatonExpressionArguments pArgs) {
            String processedModificationString = pArgs.replaceVariables(this.modificationString);
            if (processedModificationString == null) {
                pArgs.getLogger().log(Level.WARNING, new Object[]{"Modification String \"" + this.modificationString + "\" could not be processed (Variable not found)."});
                return new AutomatonExpression.ResultValue("Modification String \"" + this.modificationString + "\" could not be processed (Variable not found).", "AutomatonActionExpr.CPAModification");
            }
            for (AbstractElement ae : pArgs.getAbstractElements()) {
                AbstractQueryableElement aqe;
                if (!(ae instanceof AbstractQueryableElement) || !(aqe = (AbstractQueryableElement)ae).getCPAName().equals(this.cpaName)) continue;
                try {
                    aqe.modifyProperty(processedModificationString);
                }
                catch (InvalidQueryException e) {
                    pArgs.getLogger().logException(Level.WARNING, (Throwable)e, "Automaton encountered an Exception during Query of the " + this.cpaName + " CPA (Element " + aqe.toString() + ") on Edge " + pArgs.getCfaEdge().getDescription());
                    return defaultResultValue;
                }
            }
            return new AutomatonExpression.ResultValue("Did not find an element of the CPA \"" + this.cpaName + "\" to be modified.", "AutomatonActionExpr.CPAModification");
        }

        public String toString() {
            return "MODIFY(" + this.cpaName + "(\"" + this.modificationString + "\"))";
        }
    }

    static class Assignment
    extends AutomatonAction {
        private String varId;
        private AutomatonIntExpr var;

        public Assignment(String pVarId, AutomatonIntExpr pVar) {
            this.varId = pVarId;
            this.var = pVar;
        }

        @Override
        boolean canExecuteOn(AutomatonExpressionArguments pArgs) {
            return !this.var.eval(pArgs).canNotEvaluate();
        }

        @Override
        AutomatonExpression.ResultValue<? extends Object> eval(AutomatonExpressionArguments pArgs) {
            AutomatonExpression.ResultValue<Integer> res = this.var.eval(pArgs);
            if (res.canNotEvaluate()) {
                return res;
            }
            Map<String, AutomatonVariable> vars = pArgs.getAutomatonVariables();
            if (vars.containsKey(this.varId)) {
                vars.get(this.varId).setValue(res.getValue());
            } else {
                AutomatonVariable newVar = new AutomatonVariable("int", this.varId);
                newVar.setValue(res.getValue());
                vars.put(this.varId, newVar);
                pArgs.getLogger().log(Level.WARNING, new Object[]{"Defined a Variable " + this.varId + " that was unknown before (not set in automaton Definition)."});
            }
            return defaultResultValue;
        }
    }

    static class Print
    extends AutomatonAction {
        private List<AutomatonExpression> toPrint;

        public Print(List<AutomatonExpression> pArgs) {
            this.toPrint = pArgs;
        }

        @Override
        boolean canExecuteOn(AutomatonExpressionArguments pArgs) throws CPATransferException {
            for (AutomatonExpression expr : this.toPrint) {
                AutomatonExpression.ResultValue<?> res = expr.eval(pArgs);
                if (!res.canNotEvaluate()) continue;
                return false;
            }
            return true;
        }

        @Override
        AutomatonExpression.ResultValue<? extends Object> eval(AutomatonExpressionArguments pArgs) throws CPATransferException {
            StringBuilder sb = new StringBuilder();
            for (AutomatonExpression expr : this.toPrint) {
                AutomatonExpression.ResultValue<?> res = expr.eval(pArgs);
                if (res.canNotEvaluate()) {
                    return res;
                }
                sb.append(res.getValue().toString());
            }
            pArgs.appendToLogMessage(sb.toString());
            return defaultResultValue;
        }
    }
}

