/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.automaton;

import com.google.common.base.Optional;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.sosy_lab.cpachecker.cfa.ast.IASTNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFALabelNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.AbstractQueryableElement;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonASTComparator;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonExpression;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonExpressionArguments;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonIntExpr;
import org.sosy_lab.cpachecker.cpa.automaton.InvalidAutomatonException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.InvalidQueryException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCFAEdgeException;

interface AutomatonBoolExpr
extends AutomatonExpression {
    public static final AutomatonExpression.ResultValue<Boolean> CONST_TRUE = new AutomatonExpression.ResultValue<Boolean>(Boolean.TRUE);
    public static final AutomatonExpression.ResultValue<Boolean> CONST_FALSE = new AutomatonExpression.ResultValue<Boolean>(Boolean.FALSE);
    public static final AutomatonBoolExpr TRUE = new AutomatonBoolExpr(){

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) {
            return CONST_TRUE;
        }

        public String toString() {
            return "TRUE";
        }
    };
    public static final AutomatonBoolExpr FALSE = new AutomatonBoolExpr(){

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) {
            return CONST_FALSE;
        }

        public String toString() {
            return "FALSE";
        }
    };

    public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments var1) throws CPATransferException;

    public static class BoolNotEqTest
    implements AutomatonBoolExpr {
        private final AutomatonBoolExpr a;
        private final AutomatonBoolExpr b;

        public BoolNotEqTest(AutomatonBoolExpr pA, AutomatonBoolExpr pB) {
            this.a = pA;
            this.b = pB;
        }

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) throws CPATransferException {
            AutomatonExpression.ResultValue<Boolean> resA = this.a.eval(pArgs);
            if (resA.canNotEvaluate()) {
                return resA;
            }
            AutomatonExpression.ResultValue<Boolean> resB = this.b.eval(pArgs);
            if (resB.canNotEvaluate()) {
                return resB;
            }
            if (!resA.getValue().equals(resB.getValue())) {
                return CONST_TRUE;
            }
            return CONST_FALSE;
        }

        public String toString() {
            return this.a + " != " + this.b;
        }
    }

    public static class BoolEqTest
    implements AutomatonBoolExpr {
        private final AutomatonBoolExpr a;
        private final AutomatonBoolExpr b;

        public BoolEqTest(AutomatonBoolExpr pA, AutomatonBoolExpr pB) {
            this.a = pA;
            this.b = pB;
        }

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) throws CPATransferException {
            AutomatonExpression.ResultValue<Boolean> resA = this.a.eval(pArgs);
            if (resA.canNotEvaluate()) {
                return resA;
            }
            AutomatonExpression.ResultValue<Boolean> resB = this.b.eval(pArgs);
            if (resB.canNotEvaluate()) {
                return resB;
            }
            if (resA.getValue().equals(resB.getValue())) {
                return CONST_TRUE;
            }
            return CONST_FALSE;
        }

        public String toString() {
            return this.a + " == " + this.b;
        }
    }

    public static class Negation
    implements AutomatonBoolExpr {
        private final AutomatonBoolExpr a;

        public Negation(AutomatonBoolExpr pA) {
            this.a = pA;
        }

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) throws CPATransferException {
            AutomatonExpression.ResultValue<Boolean> resA = this.a.eval(pArgs);
            if (resA.canNotEvaluate()) {
                return resA;
            }
            if (resA.getValue().equals(Boolean.TRUE)) {
                return CONST_FALSE;
            }
            return CONST_TRUE;
        }

        public String toString() {
            return "!" + this.a;
        }
    }

    public static class And
    implements AutomatonBoolExpr {
        private final AutomatonBoolExpr a;
        private final AutomatonBoolExpr b;

        public And(AutomatonBoolExpr pA, AutomatonBoolExpr pB) {
            this.a = pA;
            this.b = pB;
        }

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) throws CPATransferException {
            AutomatonExpression.ResultValue<Boolean> resA = this.a.eval(pArgs);
            if (resA.canNotEvaluate()) {
                AutomatonExpression.ResultValue<Boolean> resB = this.b.eval(pArgs);
                if (!resB.canNotEvaluate() && resB.getValue().equals(Boolean.FALSE)) {
                    return resB;
                }
                return resA;
            }
            if (resA.getValue().equals(Boolean.FALSE)) {
                return resA;
            }
            AutomatonExpression.ResultValue<Boolean> resB = this.b.eval(pArgs);
            if (resB.canNotEvaluate()) {
                return resB;
            }
            if (resB.getValue().equals(Boolean.FALSE)) {
                return resB;
            }
            return resA;
        }

        public String toString() {
            return "(" + this.a + " && " + this.b + ")";
        }
    }

    public static class Or
    implements AutomatonBoolExpr {
        private final AutomatonBoolExpr a;
        private final AutomatonBoolExpr b;

        public Or(AutomatonBoolExpr pA, AutomatonBoolExpr pB) {
            this.a = pA;
            this.b = pB;
        }

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) throws CPATransferException {
            AutomatonExpression.ResultValue<Boolean> resA = this.a.eval(pArgs);
            if (resA.canNotEvaluate()) {
                AutomatonExpression.ResultValue<Boolean> resB = this.b.eval(pArgs);
                if (!resB.canNotEvaluate() && resB.getValue().equals(Boolean.TRUE)) {
                    return resB;
                }
                return resA;
            }
            if (resA.getValue().equals(Boolean.TRUE)) {
                return resA;
            }
            AutomatonExpression.ResultValue<Boolean> resB = this.b.eval(pArgs);
            if (resB.canNotEvaluate()) {
                return resB;
            }
            if (resB.getValue().equals(Boolean.TRUE)) {
                return resB;
            }
            return resA;
        }

        public String toString() {
            return "(" + this.a + " || " + this.b + ")";
        }
    }

    public static class IntNotEqTest
    implements AutomatonBoolExpr {
        private final AutomatonIntExpr a;
        private final AutomatonIntExpr b;

        public IntNotEqTest(AutomatonIntExpr pA, AutomatonIntExpr pB) {
            this.a = pA;
            this.b = pB;
        }

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) {
            AutomatonExpression.ResultValue<Integer> resA = this.a.eval(pArgs);
            AutomatonExpression.ResultValue<Integer> resB = this.b.eval(pArgs);
            if (resA.canNotEvaluate()) {
                return new AutomatonExpression.ResultValue<Boolean>(resA);
            }
            if (resB.canNotEvaluate()) {
                return new AutomatonExpression.ResultValue<Boolean>(resB);
            }
            if (!resA.getValue().equals(resB.getValue())) {
                return CONST_TRUE;
            }
            return CONST_FALSE;
        }

        public String toString() {
            return this.a + " != " + this.b;
        }
    }

    public static class IntEqTest
    implements AutomatonBoolExpr {
        private final AutomatonIntExpr a;
        private final AutomatonIntExpr b;

        public IntEqTest(AutomatonIntExpr pA, AutomatonIntExpr pB) {
            this.a = pA;
            this.b = pB;
        }

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) {
            AutomatonExpression.ResultValue<Integer> resA = this.a.eval(pArgs);
            AutomatonExpression.ResultValue<Integer> resB = this.b.eval(pArgs);
            if (resA.canNotEvaluate()) {
                return new AutomatonExpression.ResultValue<Boolean>(resA);
            }
            if (resB.canNotEvaluate()) {
                return new AutomatonExpression.ResultValue<Boolean>(resB);
            }
            if (resA.getValue().equals(resB.getValue())) {
                return CONST_TRUE;
            }
            return CONST_FALSE;
        }

        public String toString() {
            return this.a + " == " + this.b;
        }
    }

    public static class CPAQuery
    implements AutomatonBoolExpr {
        private final String cpaName;
        private final String queryString;

        public CPAQuery(String pCPAName, String pQuery) {
            this.cpaName = pCPAName;
            this.queryString = pQuery;
        }

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) {
            String modifiedQueryString = pArgs.replaceVariables(this.queryString);
            if (modifiedQueryString == null) {
                return new AutomatonExpression.ResultValue<Boolean>("Failed to modify queryString \"" + this.queryString + "\"", "AutomatonBoolExpr.CPAQuery");
            }
            for (AbstractElement ae : pArgs.getAbstractElements()) {
                AbstractQueryableElement aqe;
                if (!(ae instanceof AbstractQueryableElement) || !(aqe = (AbstractQueryableElement)ae).getCPAName().equals(this.cpaName)) continue;
                try {
                    Object result = aqe.evaluateProperty(modifiedQueryString);
                    if (result instanceof Boolean) {
                        if (((Boolean)result).booleanValue()) {
                            String message = "CPA-Check succeeded: ModifiedCheckString: \"" + modifiedQueryString + "\" CPAElement: (" + aqe.getCPAName() + ") \"" + aqe.toString() + "\"";
                            pArgs.getLogger().log(Level.FINER, new Object[]{message});
                            return CONST_TRUE;
                        }
                        String message = "CPA-Check failed: ModifiedCheckString: \"" + modifiedQueryString + "\" CPAElement: (" + aqe.getCPAName() + ") \"" + aqe.toString() + "\"";
                        pArgs.getLogger().log(Level.FINER, new Object[]{message});
                        return CONST_FALSE;
                    }
                    pArgs.getLogger().log(Level.WARNING, new Object[]{"Automaton got a non-Boolean value during Query of the " + this.cpaName + " CPA on Edge " + pArgs.getCfaEdge().getDescription() + ". Assuming FALSE."});
                    return CONST_FALSE;
                }
                catch (InvalidQueryException e) {
                    pArgs.getLogger().logException(Level.WARNING, (Throwable)e, "Automaton encountered an Exception during Query of the " + this.cpaName + " CPA on Edge " + pArgs.getCfaEdge().getDescription());
                    return CONST_FALSE;
                }
            }
            return new AutomatonExpression.ResultValue<Boolean>("No State of CPA \"" + this.cpaName + "\" was found!", "AutomatonBoolExpr.CPAQuery");
        }

        public String toString() {
            return "CHECK(" + this.cpaName + "(\"" + this.queryString + "\"))";
        }
    }

    public static class ALLCPAQuery
    implements AutomatonBoolExpr {
        private final String queryString;

        public ALLCPAQuery(String pString) {
            this.queryString = pString;
        }

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) {
            if (pArgs.getAbstractElements().isEmpty()) {
                return new AutomatonExpression.ResultValue<Boolean>("No CPA elements available", "AutomatonBoolExpr.ALLCPAQuery");
            }
            String modifiedQueryString = pArgs.replaceVariables(this.queryString);
            if (modifiedQueryString == null) {
                return new AutomatonExpression.ResultValue<Boolean>("Failed to modify queryString \"" + this.queryString + "\"", "AutomatonBoolExpr.ALLCPAQuery");
            }
            for (AbstractElement ae : pArgs.getAbstractElements()) {
                if (!(ae instanceof AbstractQueryableElement)) continue;
                AbstractQueryableElement aqe = (AbstractQueryableElement)ae;
                try {
                    Object result = aqe.evaluateProperty(modifiedQueryString);
                    if (!(result instanceof Boolean) || !((Boolean)result).booleanValue()) continue;
                    String message = "CPA-Check succeeded: ModifiedCheckString: \"" + modifiedQueryString + "\" CPAElement: (" + aqe.getCPAName() + ") \"" + aqe.toString() + "\"";
                    pArgs.getLogger().log(Level.FINER, new Object[]{message});
                    return CONST_TRUE;
                }
                catch (InvalidQueryException e) {
                }
            }
            return CONST_FALSE;
        }
    }

    public static class MatchCFAEdgeExact
    implements AutomatonBoolExpr {
        private final String pattern;

        public MatchCFAEdgeExact(String pPattern) {
            this.pattern = pPattern;
        }

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) {
            if (pArgs.getCfaEdge().getRawStatement().equals(this.pattern)) {
                return CONST_TRUE;
            }
            return CONST_FALSE;
        }

        public String toString() {
            return "MATCH \"" + this.pattern + "\"";
        }
    }

    public static class MatchCFAEdgeRegEx
    implements AutomatonBoolExpr {
        private final Pattern pattern;

        public MatchCFAEdgeRegEx(String pPattern) {
            this.pattern = Pattern.compile(pPattern);
        }

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) {
            if (this.pattern.matcher(pArgs.getCfaEdge().getRawStatement()).matches()) {
                return CONST_TRUE;
            }
            return CONST_FALSE;
        }

        public String toString() {
            return "MATCH [" + this.pattern + "]";
        }
    }

    public static class MatchCFAEdgeASTComparison
    implements AutomatonBoolExpr {
        private final AutomatonASTComparator.ASTMatcher patternAST;

        public MatchCFAEdgeASTComparison(String pPattern) throws InvalidAutomatonException {
            this.patternAST = AutomatonASTComparator.generatePatternAST(pPattern);
        }

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) throws UnrecognizedCFAEdgeException {
            Optional<?> ast = pArgs.getCfaEdge().getRawAST();
            if (ast.isPresent()) {
                if (!(ast.get() instanceof IASTNode)) {
                    throw new UnrecognizedCFAEdgeException(pArgs.getCfaEdge());
                }
                if (this.patternAST.matches((IASTNode)ast.get(), pArgs)) {
                    return CONST_TRUE;
                }
                return CONST_FALSE;
            }
            return CONST_FALSE;
        }

        public String toString() {
            return "MATCH {" + this.patternAST + "}";
        }
    }

    public static class MatchLabelRegEx
    implements AutomatonBoolExpr {
        private final Pattern pattern;

        public MatchLabelRegEx(String pPattern) {
            this.pattern = Pattern.compile(pPattern);
        }

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) {
            CFANode successorNode = pArgs.getCfaEdge().getSuccessor();
            if (successorNode instanceof CFALabelNode) {
                String label = ((CFALabelNode)successorNode).getLabel();
                if (this.pattern.matcher(label).matches()) {
                    return CONST_TRUE;
                }
                return CONST_FALSE;
            }
            return CONST_FALSE;
        }

        public String toString() {
            return "MATCH LABEL [" + this.pattern + "]";
        }
    }

    public static class MatchProgramExit
    implements AutomatonBoolExpr {
        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) {
            if (pArgs.getCfaEdge().getSuccessor().getNumLeavingEdges() == 0) {
                return CONST_TRUE;
            }
            return CONST_FALSE;
        }
    }
}

