/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.automaton;

import java.util.logging.Level;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.AbstractQueryableElement;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonExpressionArguments;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.InvalidQueryException;

interface AutomatonExpression {
    public ResultValue<?> eval(AutomatonExpressionArguments var1) throws CPATransferException;

    public static class ResultValue<resultType> {
        private boolean canNotEvaluate = false;
        private String failureMessage = null;
        private String failureOrigin = null;
        private resultType value = null;

        public ResultValue(resultType value) {
            this.value = value;
        }

        public ResultValue(String failureMessage, String failureOrigin) {
            this.canNotEvaluate = true;
            this.failureMessage = failureMessage;
            this.failureOrigin = failureOrigin;
        }

        public ResultValue(ResultValue<?> pRes) {
            assert (pRes.canNotEvaluate);
            this.canNotEvaluate = true;
            this.failureMessage = pRes.failureMessage;
            this.failureOrigin = pRes.failureOrigin;
        }

        boolean canNotEvaluate() {
            return this.canNotEvaluate;
        }

        String getFailureMessage() {
            return this.failureMessage;
        }

        String getFailureOrigin() {
            return this.failureOrigin;
        }

        resultType getValue() {
            return this.value;
        }
    }

    public static class CPAQuery
    implements AutomatonExpression {
        private final String cpaName;
        private final String queryString;

        public CPAQuery(String pCPAName, String pQuery) {
            this.cpaName = pCPAName;
            this.queryString = pQuery;
        }

        public ResultValue<String> eval(AutomatonExpressionArguments pArgs) {
            String modifiedQueryString = pArgs.replaceVariables(this.queryString);
            if (modifiedQueryString == null) {
                return new ResultValue<String>("Failed to modify queryString \"" + this.queryString + "\"", "AutomatonBoolExpr.CPAQuery");
            }
            for (AbstractElement ae : pArgs.getAbstractElements()) {
                AbstractQueryableElement aqe;
                if (!(ae instanceof AbstractQueryableElement) || !(aqe = (AbstractQueryableElement)ae).getCPAName().equals(this.cpaName)) continue;
                try {
                    Object result = aqe.evaluateProperty(modifiedQueryString);
                    return new ResultValue<String>(result.toString());
                }
                catch (InvalidQueryException e) {
                    pArgs.getLogger().logException(Level.WARNING, (Throwable)e, "Automaton encountered an Exception during Query of the " + this.cpaName + " CPA on Edge " + pArgs.getCfaEdge().getDescription());
                    return new ResultValue<String>("Automaton encountered an Exception during Query of the " + this.cpaName + " CPA on Edge " + pArgs.getCfaEdge().getDescription(), "AutomatonExpression.CPAQuery");
                }
            }
            return new ResultValue<String>("No State of CPA \"" + this.cpaName + "\" was found!", "AutomatonExpression.CPAQuery");
        }

        public String toString() {
            return "EVAL(" + this.cpaName + "(\"" + this.queryString + "\"))";
        }
    }

    public static class StringExpression
    implements AutomatonExpression {
        private String toPrint;

        public StringExpression(String pString) {
            this.toPrint = pString;
        }

        @Override
        public ResultValue<?> eval(AutomatonExpressionArguments pArgs) {
            String str = this.toPrint.replaceAll("\\$[rR]aw[Ss]tatement", pArgs.getCfaEdge().getRawStatement());
            str = str.replaceAll("\\$[Ll]ine", String.valueOf(pArgs.getCfaEdge().getLineNumber()));
            if ((str = pArgs.replaceVariables(str)) == null) {
                return new ResultValue("Failure in Variable Replacement in String \"" + this.toPrint + "\"", "ActionExpr.Print");
            }
            return new ResultValue<String>(str);
        }
    }
}

