/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.automaton;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonVariable;

class AutomatonExpressionArguments {
    private Map<String, AutomatonVariable> automatonVariables;
    private Map<Integer, String> transitionVariables = new HashMap<Integer, String>();
    private List<AbstractElement> abstractElements;
    private CFAEdge cfaEdge;
    private LogManager logger;
    private String transitionLogMessages = "";
    static Pattern AUTOMATON_VARS_PATTERN = Pattern.compile("\\$\\$[a-zA-Z]\\w*");
    static Pattern TRANSITION_VARS_PATTERN = Pattern.compile("\\$\\d+");

    AutomatonExpressionArguments(Map<String, AutomatonVariable> pAutomatonVariables, List<AbstractElement> pAbstractElements, CFAEdge pCfaEdge, LogManager pLogger) {
        this.automatonVariables = pAutomatonVariables == null ? Collections.emptyMap() : pAutomatonVariables;
        this.abstractElements = pAbstractElements == null ? Collections.emptyList() : pAbstractElements;
        this.cfaEdge = pCfaEdge;
        this.logger = pLogger;
    }

    void setAutomatonVariables(Map<String, AutomatonVariable> pAutomatonVariables) {
        this.automatonVariables = pAutomatonVariables;
    }

    Map<String, AutomatonVariable> getAutomatonVariables() {
        return this.automatonVariables;
    }

    List<AbstractElement> getAbstractElements() {
        return this.abstractElements;
    }

    CFAEdge getCfaEdge() {
        return this.cfaEdge;
    }

    LogManager getLogger() {
        return this.logger;
    }

    void appendToLogMessage(String message) {
        this.transitionLogMessages = this.transitionLogMessages + message;
    }

    void appendToLogMessage(int message) {
        this.transitionLogMessages = this.transitionLogMessages + message;
    }

    String getLogMessage() {
        return this.transitionLogMessages;
    }

    public void clearLogMessage() {
        this.transitionLogMessages = "";
    }

    void clearTransitionVariables() {
        this.transitionVariables.clear();
    }

    String getTransitionVariable(int key) {
        return this.transitionVariables.get(key);
    }

    void putTransitionVariable(int key, String value) {
        this.transitionVariables.put(key, value);
    }

    String replaceVariables(String pSourceString) {
        Matcher matcher = TRANSITION_VARS_PATTERN.matcher(pSourceString);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(result, "");
            String key = matcher.group().substring(1);
            try {
                int varKey = Integer.parseInt(key);
                String var = this.getTransitionVariable(varKey);
                if (var == null) {
                    this.getLogger().log(Level.WARNING, new Object[]{"could not replace the transition variable $" + varKey + " (not found)."});
                    return null;
                }
                result.append(var);
            }
            catch (NumberFormatException e) {
                this.getLogger().log(Level.WARNING, new Object[]{"could not parse the int in " + matcher.group() + " , leaving it untouched"});
                result.append(matcher.group());
            }
        }
        matcher.appendTail(result);
        matcher = AUTOMATON_VARS_PATTERN.matcher(result.toString());
        result = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(result, "");
            String varName = matcher.group().substring(2);
            AutomatonVariable variable = this.getAutomatonVariables().get(varName);
            if (variable == null) {
                this.getLogger().log(Level.WARNING, new Object[]{"could not replace the Automaton variable reference " + varName + " (not found)."});
                return null;
            }
            result.append(variable.getValue());
        }
        matcher.appendTail(result);
        return result.toString();
    }

    public Map<Integer, String> getTransitionVariables() {
        return this.transitionVariables;
    }

    public void putTransitionVariables(Map<Integer, String> pTransitionVariables) {
        this.transitionVariables.putAll(pTransitionVariables);
    }
}

