/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.automaton;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonAction;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonBoolExpr;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonTransition;
import org.sosy_lab.cpachecker.cpa.automaton.InvalidAutomatonException;

public class AutomatonInternalState {
    private static int stateIdCounter = 0;
    private int stateId = stateIdCounter++;
    static final AutomatonInternalState BOTTOM = new AutomatonInternalState("_predefinedState_BOTTOM", Collections.<AutomatonTransition>emptyList());
    static final AutomatonInternalState ERROR = new AutomatonInternalState("_predefinedState_ERROR", Collections.singletonList(new AutomatonTransition(AutomatonBoolExpr.TRUE, Collections.<AutomatonBoolExpr>emptyList(), Collections.<AutomatonAction>emptyList(), BOTTOM)), true, false);
    private final String name;
    private final List<AutomatonTransition> transitions;
    private final boolean mIsTarget;
    private final boolean mAllTransitions;

    public AutomatonInternalState(String pName, List<AutomatonTransition> pTransitions, boolean pIsTarget, boolean pAllTransitions) {
        this.name = pName;
        this.transitions = pTransitions;
        this.mIsTarget = pIsTarget;
        this.mAllTransitions = pAllTransitions;
    }

    public AutomatonInternalState(String pName, List<AutomatonTransition> pTransitions) {
        this(pName, pTransitions, false, false);
    }

    public boolean isNonDetState() {
        return this.mAllTransitions;
    }

    void setFollowStates(Map<String, AutomatonInternalState> pAllStates) throws InvalidAutomatonException {
        for (AutomatonTransition t : this.transitions) {
            t.setFollowState(pAllStates);
        }
    }

    public String getName() {
        return this.name;
    }

    public int getStateId() {
        return this.stateId;
    }

    public boolean isTarget() {
        return this.mIsTarget;
    }

    public List<AutomatonTransition> getTransitions() {
        return this.transitions;
    }

    public String toString() {
        return this.name;
    }
}

