/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.automaton;

import java.io.File;
import java.io.FileInputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java_cup.runtime.ComplexSymbolFactory;
import java_cup.runtime.Symbol;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.cpachecker.cfa.ast.IASTStatement;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonASTComparator;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonBoolExpr;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonExpressionArguments;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonScanner;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonVariable;
import org.sosy_lab.cpachecker.cpa.automaton.InvalidAutomatonException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;

class AutomatonInternalTests {
    AutomatonInternalTests() {
    }

    public static void main(String[] args) throws CPATransferException {
        try {
            File f = new File("test/config/automata/defaultSpecification.spc");
            Configuration emptyConfig = Configuration.defaultConfiguration();
            LogManager logger = new LogManager(emptyConfig);
            ComplexSymbolFactory sf1 = new ComplexSymbolFactory();
            AutomatonScanner s = new AutomatonScanner(new FileInputStream(f), f, emptyConfig, logger, sf1);
            Symbol symb = s.next_token();
            while (symb.sym != 0) {
                System.out.println(symb);
                symb = s.next_token();
            }
            System.out.println(s.next_token());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        AutomatonInternalTests.testAndOr();
    }

    private static void testAndOr() throws CPATransferException {
        AutomatonBoolExpr.CPAQuery cannot = new AutomatonBoolExpr.CPAQuery("none", "none");
        Map<String, AutomatonVariable> vars = Collections.emptyMap();
        List<AbstractElement> elements = Collections.emptyList();
        AutomatonExpressionArguments args = new AutomatonExpressionArguments(vars, elements, null, null);
        boolean ok = true;
        AutomatonBoolExpr myTrue = AutomatonBoolExpr.TRUE;
        AutomatonBoolExpr myFalse = AutomatonBoolExpr.FALSE;
        AutomatonBoolExpr ex = new AutomatonBoolExpr.And(myTrue, myTrue);
        if (!ex.eval(args).getValue().equals(Boolean.TRUE)) {
            ok = false;
        }
        if (!(ex = new AutomatonBoolExpr.And(myTrue, myFalse)).eval(args).getValue().equals(Boolean.FALSE)) {
            ok = false;
        }
        if (!(ex = new AutomatonBoolExpr.And(myTrue, cannot)).eval(args).canNotEvaluate()) {
            ok = false;
        }
        if (!(ex = new AutomatonBoolExpr.And(myFalse, myTrue)).eval(args).getValue().equals(Boolean.FALSE)) {
            ok = false;
        }
        if (!(ex = new AutomatonBoolExpr.And(myFalse, myFalse)).eval(args).getValue().equals(Boolean.FALSE)) {
            ok = false;
        }
        if (!(ex = new AutomatonBoolExpr.And(myFalse, cannot)).eval(args).getValue().equals(Boolean.FALSE)) {
            ok = false;
        }
        if (!(ex = new AutomatonBoolExpr.And(cannot, myTrue)).eval(args).canNotEvaluate()) {
            ok = false;
        }
        if (!(ex = new AutomatonBoolExpr.And(cannot, myFalse)).eval(args).getValue().equals(Boolean.FALSE)) {
            ok = false;
        }
        if (!(ex = new AutomatonBoolExpr.And(cannot, cannot)).eval(args).canNotEvaluate()) {
            ok = false;
        }
        if (!(ex = new AutomatonBoolExpr.Or(myTrue, myTrue)).eval(args).getValue().equals(Boolean.TRUE)) {
            ok = false;
        }
        if (!(ex = new AutomatonBoolExpr.Or(myTrue, myFalse)).eval(args).getValue().equals(Boolean.TRUE)) {
            ok = false;
        }
        if (!(ex = new AutomatonBoolExpr.Or(myTrue, cannot)).eval(args).getValue().equals(Boolean.TRUE)) {
            ok = false;
        }
        if (!(ex = new AutomatonBoolExpr.Or(myFalse, myTrue)).eval(args).getValue().equals(Boolean.TRUE)) {
            ok = false;
        }
        if (!(ex = new AutomatonBoolExpr.Or(myFalse, myFalse)).eval(args).getValue().equals(Boolean.FALSE)) {
            ok = false;
        }
        if (!(ex = new AutomatonBoolExpr.Or(myFalse, cannot)).eval(args).canNotEvaluate()) {
            ok = false;
        }
        if (!(ex = new AutomatonBoolExpr.Or(cannot, myTrue)).eval(args).getValue().equals(Boolean.TRUE)) {
            ok = false;
        }
        if (!(ex = new AutomatonBoolExpr.Or(cannot, myFalse)).eval(args).canNotEvaluate()) {
            ok = false;
        }
        if (!(ex = new AutomatonBoolExpr.Or(cannot, cannot)).eval(args).canNotEvaluate()) {
            ok = false;
        }
        if (!ok) {
            System.out.println("AndOr test has failed!");
        } else {
            System.out.println("AndOr Test was OK");
        }
    }

    private static void testExpressionEvaluator() {
    }

    private static void testASTcomparison() {
        AutomatonInternalTests.testAST("x=5;", "x= $?;");
        AutomatonInternalTests.testAST("x=5;", "x= 10;");
        AutomatonInternalTests.testAST("x=5;", "$? =10;");
        AutomatonInternalTests.testAST("x  = 5;", "$?=$?;");
        AutomatonInternalTests.testAST("a = 5;", "b    = 5;");
        AutomatonInternalTests.testAST("init(a);", "init($?);");
        AutomatonInternalTests.testAST("init();", "init($?);");
        AutomatonInternalTests.testAST("init(a, b);", "init($?, b);");
        AutomatonInternalTests.testAST("init(a, b);", "init($?, c);");
        AutomatonInternalTests.testAST("init();", "init();;");
        AutomatonInternalTests.testAST("x = 5;", "x=$?");
        AutomatonInternalTests.testAST("x = 5", "x=$?;");
        AutomatonInternalTests.testAST("x = 5;;", "x=$?");
        AutomatonInternalTests.testAST("f();", "f($?);");
        AutomatonInternalTests.testAST("f(x);", "f($?);");
        AutomatonInternalTests.testAST("f(x, y);", "f($?);");
        AutomatonInternalTests.testAST("f(x);", "f(x, $?);");
        AutomatonInternalTests.testAST("f(x, y);", "f(x, $?);");
        AutomatonInternalTests.testAST("f(x, y, z);", "f(x, $?);");
    }

    static void testAST(String src, String pattern) {
        System.out.print("AST Test of ");
        System.out.print(src);
        System.out.print(" and ");
        System.out.print(pattern);
        System.out.print(" returns ");
        AutomatonExpressionArguments args = new AutomatonExpressionArguments(null, null, null, null);
        try {
            IASTStatement sourceAST = AutomatonASTComparator.generateSourceAST(src);
            AutomatonASTComparator.ASTMatcher patternAST = AutomatonASTComparator.generatePatternAST(pattern);
            System.out.print(patternAST.matches(sourceAST, args));
        }
        catch (InvalidAutomatonException e) {
            System.out.println(e.getMessage());
        }
        System.out.println();
    }
}

