/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.automaton;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.sosy_lab.cpachecker.core.interfaces.AbstractQueryableElement;
import org.sosy_lab.cpachecker.core.interfaces.Targetable;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonInternalState;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonTransition;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonVariable;
import org.sosy_lab.cpachecker.cpa.automaton.ControlAutomatonCPA;
import org.sosy_lab.cpachecker.exceptions.InvalidQueryException;
import org.sosy_lab.cpachecker.util.globalinfo.GlobalInfo;

public class AutomatonState
implements AbstractQueryableElement,
Targetable,
Serializable {
    private static final long serialVersionUID = -4665039439114057346L;
    private static final String AutomatonAnalysisNamePrefix = "AutomatonAnalysis_";
    private final transient ControlAutomatonCPA automatonCPA;
    private final Map<String, AutomatonVariable> vars;
    private transient AutomatonInternalState internalState;

    static AutomatonState automatonStateFactory(Map<String, AutomatonVariable> pVars, AutomatonInternalState pInternalState, ControlAutomatonCPA pAutomatonCPA) {
        if (pInternalState == AutomatonInternalState.BOTTOM) {
            return pAutomatonCPA.getBottomState();
        }
        return new AutomatonState(pVars, pInternalState, pAutomatonCPA);
    }

    private AutomatonState(Map<String, AutomatonVariable> pVars, AutomatonInternalState pInternalState, ControlAutomatonCPA pAutomatonCPA) {
        this.vars = (Map)Preconditions.checkNotNull(pVars);
        this.internalState = (AutomatonInternalState)Preconditions.checkNotNull((Object)pInternalState);
        this.automatonCPA = (ControlAutomatonCPA)Preconditions.checkNotNull((Object)pAutomatonCPA);
    }

    @Override
    public boolean isTarget() {
        return this.internalState.isTarget();
    }

    public boolean equals(Object pObj) {
        if (this == pObj) {
            return true;
        }
        if (pObj == null) {
            return false;
        }
        if (!pObj.getClass().equals(AutomatonState.class)) {
            return false;
        }
        AutomatonState otherState = (AutomatonState)pObj;
        return this.internalState.equals(otherState.internalState) && ((Object)this.vars).equals(otherState.vars);
    }

    public int hashCode() {
        return this.internalState == null ? super.hashCode() : this.internalState.hashCode() * 17 + ((Object)this.vars).hashCode();
    }

    public String toString() {
        return (this.automatonCPA != null ? this.automatonCPA.getAutomaton().getName() + ": " : "") + this.internalState.getName() + ' ' + Joiner.on((char)' ').withKeyValueSeparator("=").join(this.vars);
    }

    @Override
    public boolean checkProperty(String pProperty) throws InvalidQueryException {
        String[] parts = pProperty.split("==");
        if (parts.length != 2) {
            throw new InvalidQueryException("The Query \"" + pProperty + "\" is invalid. Could not split the property string correctly.");
        }
        if (parts[0].trim().toLowerCase().equals("state")) {
            return this.getInternalState().getName().equals(parts[1].trim());
        }
        if (this.vars.containsKey(parts[0].trim())) {
            try {
                int val = Integer.parseInt(parts[1]);
                return this.vars.get(parts[0]).getValue() == val;
            }
            catch (NumberFormatException e) {
                throw new InvalidQueryException("The Query \"" + pProperty + "\" is invalid. Could not parse the int \"" + parts[1] + "\".");
            }
        }
        throw new InvalidQueryException("The Query \"" + pProperty + "\" is invalid. Only accepting \"State == something\" and \"varname = something\" queries so far.");
    }

    @Override
    public void modifyProperty(String pModification) throws InvalidQueryException {
        String[] parts = pModification.split(":=");
        if (parts.length != 2) {
            throw new InvalidQueryException("The Query \"" + pModification + "\" is invalid. Could not split the string correctly.");
        }
        AutomatonVariable var = this.vars.get(parts[0].trim());
        if (var != null) {
            try {
                int val = Integer.parseInt(parts[1]);
                var.setValue(val);
            }
            catch (NumberFormatException e) {
                throw new InvalidQueryException("The Query \"" + pModification + "\" is invalid. Could not parse the int \"" + parts[1].trim() + "\".");
            }
        } else {
            throw new InvalidQueryException("Could not modify the variable \"" + parts[0].trim() + "\" (Variable not found)");
        }
    }

    @Override
    public Boolean evaluateProperty(String pProperty) throws InvalidQueryException {
        return this.checkProperty(pProperty);
    }

    @Override
    public String getCPAName() {
        return AutomatonAnalysisNamePrefix + this.automatonCPA.getAutomaton().getName();
    }

    AutomatonInternalState getInternalState() {
        return this.internalState;
    }

    public String getInternalStateName() {
        return this.internalState.getName();
    }

    Map<String, AutomatonVariable> getVars() {
        return this.vars;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.internalState.getStateId());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int stateId = in.readInt();
        this.internalState = GlobalInfo.getInstance().getAutomatonInfo().getStateById(stateId);
    }

    static class AutomatonUnknownState
    extends AutomatonState {
        private static final long serialVersionUID = -2010032222354565037L;
        private final AutomatonState previousState;

        AutomatonUnknownState(AutomatonState pPreviousState) {
            super(pPreviousState.getVars(), pPreviousState.getInternalState(), pPreviousState.automatonCPA);
            this.previousState = pPreviousState;
        }

        AutomatonState getPreviousState() {
            return this.previousState;
        }

        @Override
        public boolean equals(Object pObj) {
            if (this == pObj) {
                return true;
            }
            if (!(pObj instanceof AutomatonUnknownState)) {
                return false;
            }
            AutomatonUnknownState otherState = (AutomatonUnknownState)pObj;
            return this.previousState.equals(otherState.previousState);
        }

        @Override
        public int hashCode() {
            return this.previousState.hashCode() + 724;
        }

        @Override
        public String toString() {
            return "AutomatonUnknownState<" + this.previousState.toString() + ">";
        }
    }

    static class BOTTOM
    extends AutomatonState {
        private static final long serialVersionUID = -401794748742705212L;

        public BOTTOM(ControlAutomatonCPA pAutomatonCPA) {
            super(Collections.emptyMap(), AutomatonInternalState.BOTTOM, pAutomatonCPA);
        }

        @Override
        public boolean checkProperty(String pProperty) throws InvalidQueryException {
            return pProperty.toLowerCase().equals("state == bottom");
        }

        @Override
        public String toString() {
            return "AutomatonState.BOTTOM";
        }
    }

    static class TOP
    extends AutomatonState {
        private static final long serialVersionUID = -7848577870312049023L;

        public TOP(ControlAutomatonCPA pAutomatonCPA) {
            super(Collections.emptyMap(), new AutomatonInternalState("_predefinedState_TOP", Collections.<AutomatonTransition>emptyList()), pAutomatonCPA);
        }

        @Override
        public boolean checkProperty(String pProperty) throws InvalidQueryException {
            return pProperty.toLowerCase().equals("state == top");
        }

        @Override
        public String toString() {
            return "AutomatonState.TOP";
        }
    }
}

