/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.automaton;

import java.io.PrintStream;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonTransferRelation;
import org.sosy_lab.cpachecker.cpa.automaton.ControlAutomatonCPA;

class AutomatonStatistics
implements Statistics {
    private final ControlAutomatonCPA mCpa;

    public AutomatonStatistics(ControlAutomatonCPA pCpa) {
        this.mCpa = pCpa;
    }

    @Override
    public String getName() {
        return "AutomatonAnalysis (" + this.mCpa.getAutomaton().getName() + ")";
    }

    @Override
    public void printStatistics(PrintStream out, CPAcheckerResult.Result pResult, ReachedSet pReached) {
        AutomatonTransferRelation trans = this.mCpa.getTransferRelation();
        out.println("Number of states:                    " + this.mCpa.getAutomaton().getNumberOfStates());
        out.println("Total time for sucessor computation: " + trans.totalPostTime);
        if (trans.totalPostTime.getSumTime() >= 500L) {
            out.println("  Time for transition matches:       " + trans.matchTime);
            out.println("  Time for transition assertions:    " + trans.assertionsTime);
            out.println("  Time for transition actions:       " + trans.actionTime);
        }
        if (trans.totalStrengthenTime.getNumberOfIntervals() > 0) {
            out.println("Total time for strengthen operator:  " + trans.totalStrengthenTime);
        }
    }
}

