/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.automaton;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.junit.Assert;
import org.junit.Test;
import org.sosy_lab.common.Files;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.cpachecker.cfa.ast.IASTStatement;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.core.CPAchecker;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonASTComparator;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonExpressionArguments;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonVariable;
import org.sosy_lab.cpachecker.cpa.automaton.InvalidAutomatonException;

public class AutomatonTest {
    private static final String OUTPUT_FILE = "output/AutomatonExport.dot";

    @Test
    public void CyclicInclusionTest() throws Exception {
        ImmutableMap prop = ImmutableMap.of((Object)"CompositeCPA.cpas", (Object)"cpa.location.LocationCPA, cpa.pointer.PointerCPA, cpa.uninitvars.UninitializedVariablesCPA, cpa.types.TypesCPA", (Object)"specification", (Object)"test/config/automata/tmpSpecification.spc", (Object)"log.consoleLevel", (Object)"INFO", (Object)"analysis.stopAfterError", (Object)"FALSE");
        File tmpSpc = new File("test/config/automata/tmpSpecification.spc");
        String content = "#include UninitializedVariablesTestAutomaton.txt \n#include tmpSpecification.spc \n";
        Files.writeFile((File)tmpSpc, (Object)content);
        TestResults results = this.run((Map<String, String>)prop, "test/programs/simple/UninitVarsErrors.c");
        Assert.assertTrue((boolean)results.isSafe());
        Assert.assertTrue((boolean)results.logContains("File \"test/config/automata/tmpSpecification.spc\" was referenced multiple times."));
        Assert.assertTrue((String)"Could not delete temporary specification", (boolean)tmpSpc.delete());
    }

    @Test
    public void IncludeSpecificationTest() throws Exception {
        ImmutableMap prop = ImmutableMap.of((Object)"CompositeCPA.cpas", (Object)"cpa.location.LocationCPA, cpa.pointer.PointerCPA, cpa.uninitvars.UninitializedVariablesCPA, cpa.types.TypesCPA", (Object)"specification", (Object)"test/config/automata/defaultSpecificationForTesting.spc", (Object)"log.consoleLevel", (Object)"INFO", (Object)"analysis.stopAfterError", (Object)"FALSE");
        TestResults results = this.run((Map<String, String>)prop, "test/programs/simple/UninitVarsErrors.c");
        Assert.assertTrue((boolean)results.logContains("Automaton: Uninitialized return value"));
        Assert.assertTrue((boolean)results.logContains("Automaton: Uninitialized variable used"));
        results = this.run((Map<String, String>)prop, "test/programs/simple/PointerAnalysisErrors.c");
        Assert.assertTrue((boolean)results.logContains("Found a DOUBLE_FREE"));
        Assert.assertTrue((boolean)results.logContains("Found an INVALID_FREE"));
        Assert.assertTrue((boolean)results.logContains("Found a POTENTIALLY_UNSAFE_DEREFERENCE"));
        Assert.assertTrue((boolean)results.logContains("Found a Memory Leak"));
        Assert.assertTrue((boolean)results.logContains("Found an UNSAFE_DEREFERENCE"));
    }

    @Test
    public void SpecificationAndNoCompositeTest() throws Exception {
        ImmutableMap prop = ImmutableMap.of((Object)"cpa", (Object)"cpa.location.LocationCPA", (Object)"log.consoleLevel", (Object)"INFO", (Object)"specification", (Object)"test/config/automata/LockingAutomatonAll.txt");
        TestResults results = this.run((Map<String, String>)prop, "test/programs/simple/modificationExample.c");
        Assert.assertTrue((boolean)results.logContains("Option specification gave specification automata, but no CompositeCPA was used"));
        Assert.assertTrue((boolean)results.getCheckerResult().getResult().equals((Object)CPAcheckerResult.Result.UNKNOWN));
    }

    @Test
    public void modificationTestWithSpecification() throws Exception {
        ImmutableMap prop = ImmutableMap.of((Object)"CompositeCPA.cpas", (Object)"cpa.location.LocationCPA, cpa.explicit.ExplicitCPA", (Object)"specification", (Object)"test/config/automata/modifyingAutomaton.txt", (Object)"log.consoleLevel", (Object)"INFO", (Object)"cpa.explicit.threshold", (Object)"10");
        TestResults results = this.run((Map<String, String>)prop, "test/programs/simple/modificationExample.c");
        Assert.assertTrue((boolean)results.logContains("MODIFIED"));
        Assert.assertTrue((boolean)results.logContains("Modification successful"));
        Assert.assertTrue((boolean)results.isSafe());
    }

    @Test
    public void MatchEndOfProgramTest() throws Exception {
        ImmutableMap prop = ImmutableMap.of((Object)"CompositeCPA.cpas", (Object)"cpa.location.LocationCPA", (Object)"specification", (Object)"test/config/automata/PrintLastStatementAutomaton.spc", (Object)"log.consoleLevel", (Object)"INFO", (Object)"analysis.stopAfterError", (Object)"TRUE");
        TestResults results = this.run((Map<String, String>)prop, "test/programs/simple/loop1.c");
        Assert.assertTrue((boolean)results.logContains("Last statement is \"return (0);\""));
        Assert.assertTrue((boolean)results.logContains("Last statement is \"return (-1);\""));
        Assert.assertTrue((boolean)results.isSafe());
    }

    @Test
    public void failIfNoAutomatonGiven() throws Exception {
        ImmutableMap prop = ImmutableMap.of((Object)"CompositeCPA.cpas", (Object)"cpa.location.LocationCPA, cpa.explicit.ExplicitCPA, cpa.automaton.ControlAutomatonCPA", (Object)"log.consoleLevel", (Object)"INFO", (Object)"cpa.explicit.threshold", (Object)"10");
        TestResults results = this.run((Map<String, String>)prop, "test/programs/simple/modificationExample.c");
        Assert.assertTrue((boolean)results.getCheckerResult().getResult().equals((Object)CPAcheckerResult.Result.UNKNOWN));
        Assert.assertTrue((boolean)results.logContains("Explicitly specified automaton CPA needs option cpa.automaton.inputFile!"));
    }

    @Test
    public void modificationTest() throws Exception {
        ImmutableMap prop = ImmutableMap.of((Object)"CompositeCPA.cpas", (Object)"cpa.location.LocationCPA, cpa.explicit.ExplicitCPA, cpa.automaton.ControlAutomatonCPA", (Object)"cpa.automaton.inputFile", (Object)"test/config/automata/modifyingAutomaton.txt", (Object)"log.consoleLevel", (Object)"INFO", (Object)"cpa.explicit.threshold", (Object)"10");
        TestResults results = this.run((Map<String, String>)prop, "test/programs/simple/modificationExample.c");
        Assert.assertTrue((boolean)results.logContains("MODIFIED"));
        Assert.assertTrue((boolean)results.logContains("Modification successful"));
        Assert.assertTrue((boolean)results.isSafe());
    }

    @Test
    public void modification_in_Observer_throws_Test() throws Exception {
        ImmutableMap prop = ImmutableMap.of((Object)"CompositeCPA.cpas", (Object)"cpa.location.LocationCPA, cpa.explicit.ExplicitCPA, cpa.automaton.ObserverAutomatonCPA", (Object)"cpa.automaton.inputFile", (Object)"test/config/automata/modifyingAutomaton.txt", (Object)"log.consoleLevel", (Object)"SEVERE", (Object)"cpa.explicit.threshold", (Object)"10");
        TestResults results = this.run((Map<String, String>)prop, "test/programs/simple/modificationExample.c");
        Assert.assertTrue((boolean)results.logContains("Invalid configuration: The Transition MATCH "));
    }

    @Test
    public void setuidTest() throws Exception {
        ImmutableMap prop = ImmutableMap.of((Object)"CompositeCPA.cpas", (Object)"cpa.location.LocationCPA, cpa.automaton.ObserverAutomatonCPA", (Object)"cpa.automaton.inputFile", (Object)"test/config/automata/simple_setuid.txt", (Object)"log.consoleLevel", (Object)"INFO", (Object)"analysis.stopAfterError", (Object)"FALSE");
        TestResults results = this.run((Map<String, String>)prop, "test/programs/simple/simple_setuid_test.c");
        Assert.assertTrue((boolean)results.logContains("Systemcall in line 10 with userid 2"));
        Assert.assertTrue((boolean)results.logContains("going to ErrorState on edge \"system(40);\""));
        Assert.assertTrue((boolean)results.isUnsafe());
    }

    @Test
    public void uninitVarsTest() throws Exception {
        ImmutableMap prop = ImmutableMap.of((Object)"CompositeCPA.cpas", (Object)"cpa.location.LocationCPA, cpa.automaton.ObserverAutomatonCPA, cpa.uninitvars.UninitializedVariablesCPA, cpa.types.TypesCPA", (Object)"cpa.automaton.inputFile", (Object)"test/config/automata/UninitializedVariablesTestAutomaton.txt", (Object)"log.consoleLevel", (Object)"FINER", (Object)"cpa.automaton.dotExportFile", (Object)OUTPUT_FILE, (Object)"analysis.stopAfterError", (Object)"FALSE");
        TestResults results = this.run((Map<String, String>)prop, "test/programs/simple/UninitVarsErrors.c");
        Assert.assertTrue((boolean)results.logContains("Automaton: Uninitialized return value"));
        Assert.assertTrue((boolean)results.logContains("Automaton: Uninitialized variable used"));
    }

    @Test
    public void pointerAnalyisTest() throws Exception {
        ImmutableMap prop = ImmutableMap.of((Object)"CompositeCPA.cpas", (Object)"cpa.location.LocationCPA, cpa.automaton.ObserverAutomatonCPA, cpa.pointer.PointerCPA", (Object)"cpa.automaton.inputFile", (Object)"test/config/automata/PointerAnalysisTestAutomaton.txt", (Object)"log.consoleLevel", (Object)"INFO", (Object)"cpa.automaton.dotExportFile", (Object)OUTPUT_FILE, (Object)"analysis.stopAfterError", (Object)"FALSE");
        TestResults results = this.run((Map<String, String>)prop, "test/programs/simple/PointerAnalysisErrors.c");
        Assert.assertTrue((boolean)results.logContains("Found a DOUBLE_FREE"));
        Assert.assertTrue((boolean)results.logContains("Found an INVALID_FREE"));
        Assert.assertTrue((boolean)results.logContains("Found a POTENTIALLY_UNSAFE_DEREFERENCE"));
        Assert.assertTrue((boolean)results.logContains("Found a Memory Leak"));
        Assert.assertTrue((boolean)results.logContains("Found an UNSAFE_DEREFERENCE"));
    }

    @Test
    public void pointerAnalyisSkeletonTest() throws Exception {
        ImmutableMap prop = ImmutableMap.of((Object)"CompositeCPA.cpas", (Object)"cpa.location.LocationCPA, cpa.automaton.ObserverAutomatonCPA, cpa.pointer.PointerCPA", (Object)"cpa.automaton.inputFile", (Object)"test/config/automata/PointerAnalysisTestSkeletonAutomaton.txt", (Object)"log.consoleLevel", (Object)"INFO");
        TestResults results = this.run((Map<String, String>)prop, "test/programs/simple/PointerAnalysisErrors.c");
        Assert.assertTrue((boolean)results.logContains("Automaton going to ErrorState on edge \"free(a);\""));
        Assert.assertTrue((boolean)results.isUnsafe());
    }

    @Test
    public void locking_correct() throws Exception {
        ImmutableMap prop = ImmutableMap.of((Object)"CompositeCPA.cpas", (Object)"cpa.location.LocationCPA, cpa.automaton.ObserverAutomatonCPA", (Object)"cpa.automaton.inputFile", (Object)"test/config/automata/LockingAutomatonAll.txt", (Object)"log.consoleLevel", (Object)"INFO", (Object)"cpa.automaton.dotExportFile", (Object)OUTPUT_FILE);
        TestResults results = this.run((Map<String, String>)prop, "test/programs/simple/locking_correct.c");
        Assert.assertTrue((boolean)results.isSafe());
    }

    @Test
    public void locking_incorrect() throws Exception {
        ImmutableMap prop = ImmutableMap.of((Object)"CompositeCPA.cpas", (Object)"cpa.location.LocationCPA, cpa.automaton.ObserverAutomatonCPA", (Object)"cpa.automaton.inputFile", (Object)"test/config/automata/LockingAutomatonAll.txt", (Object)"log.consoleLevel", (Object)"INFO");
        TestResults results = this.run((Map<String, String>)prop, "test/programs/simple/locking_incorrect.c");
        Assert.assertTrue((boolean)results.isUnsafe());
    }

    @Test
    public void explicitAnalysis_observing() throws Exception {
        ImmutableMap prop = ImmutableMap.of((Object)"CompositeCPA.cpas", (Object)"cpa.location.LocationCPA, cpa.automaton.ObserverAutomatonCPA, cpa.explicit.ExplicitCPA", (Object)"cpa.automaton.inputFile", (Object)"test/config/automata/ExcplicitAnalysisObservingAutomaton.txt", (Object)"log.consoleLevel", (Object)"INFO", (Object)"cpa.explicit.threshold", (Object)"2000");
        TestResults results = this.run((Map<String, String>)prop, "test/programs/simple/ex2.cil.c");
        Assert.assertTrue((boolean)results.logContains("st==3 after Edge st = 3;"));
        Assert.assertTrue((boolean)results.logContains("st==1 after Edge st = 1;"));
        Assert.assertTrue((boolean)results.logContains("st==2 after Edge st = 2;"));
        Assert.assertTrue((boolean)results.logContains("st==4 after Edge st = 4;"));
        Assert.assertTrue((boolean)results.isSafe());
    }

    @Test
    public void functionIdentifying() throws Exception {
        ImmutableMap prop = ImmutableMap.of((Object)"CompositeCPA.cpas", (Object)"cpa.location.LocationCPA, cpa.automaton.ObserverAutomatonCPA", (Object)"cpa.automaton.inputFile", (Object)"test/config/automata/FunctionIdentifyingAutomaton.txt", (Object)"log.consoleLevel", (Object)"FINER");
        TestResults results = this.run((Map<String, String>)prop, "test/programs/simple/functionCall.c");
        Assert.assertTrue((boolean)results.logContains("i'm in Main after Edge int y;"));
        Assert.assertTrue((boolean)results.logContains("i'm in f after Edge y = f()"));
        Assert.assertTrue((boolean)results.logContains("i'm in f after Edge int x;"));
        Assert.assertTrue((boolean)results.logContains("i'm in Main after Edge Return Edge to"));
        Assert.assertTrue((boolean)results.logContains("i'm in Main after Edge Label: ERROR"));
    }

    @Test
    public void transitionVariableReplacement() throws Exception {
        Map<String, AutomatonVariable> pAutomatonVariables = null;
        List<AbstractElement> pAbstractElements = null;
        CFAEdge pCfaEdge = null;
        LogManager pLogger = new LogManager(Configuration.builder().setOption("log.level", "OFF").setOption("log.consoleLevel", "WARNING").build());
        AutomatonExpressionArguments args = new AutomatonExpressionArguments(pAutomatonVariables, pAbstractElements, pCfaEdge, pLogger);
        args.putTransitionVariable(1, "hi");
        args.putTransitionVariable(2, "hello");
        String result = args.replaceVariables("$1 == $2");
        Assert.assertTrue((boolean)"hi == hello".equals(result));
        result = args.replaceVariables("$1 == $1");
        Assert.assertTrue((boolean)"hi == hi".equals(result));
        pLogger.log(Level.WARNING, new Object[]{"Warning expected in the next line (concerning $5)"});
        result = args.replaceVariables("$1 == $5");
        Assert.assertTrue((result == null ? 1 : 0) != 0);
    }

    @Test
    public void testJokerReplacementInAST() throws InvalidAutomatonException {
        AutomatonASTComparator.ASTMatcher patternAST = AutomatonASTComparator.generatePatternAST("$20 = $5($1, $?);");
        IASTStatement sourceAST = AutomatonASTComparator.generateSourceAST("var1 = function(var2, egal);");
        AutomatonExpressionArguments args = new AutomatonExpressionArguments(null, null, null, null);
        boolean result = patternAST.matches(sourceAST, args);
        Assert.assertTrue((boolean)result);
        Assert.assertTrue((boolean)args.getTransitionVariable(20).equals("var1"));
        Assert.assertTrue((boolean)args.getTransitionVariable(1).equals("var2"));
        Assert.assertTrue((boolean)args.getTransitionVariable(5).equals("function"));
    }

    @Test
    public void interacting_Automata() throws Exception {
        ImmutableMap prop = ImmutableMap.of((Object)"CompositeCPA.cpas", (Object)"cpa.location.LocationCPA, cpa.automaton.ObserverAutomatonCPA automatonA, cpa.automaton.ObserverAutomatonCPA automatonB, cpa.explicit.ExplicitCPA", (Object)"automatonA.cpa.automaton.inputFile", (Object)"test/config/automata/InteractionAutomatonA.txt", (Object)"automatonB.cpa.automaton.inputFile", (Object)"test/config/automata/InteractionAutomatonB.txt", (Object)"log.consoleLevel", (Object)"INFO", (Object)"cpa.explicit.threshold", (Object)"2000");
        TestResults results = this.run((Map<String, String>)prop, "test/programs/simple/loop1.c");
        Assert.assertTrue((boolean)results.logContains("A: Matched i in line 9 x=2"));
        Assert.assertTrue((boolean)results.logContains("B: A increased to 2 And i followed "));
        Assert.assertTrue((boolean)results.isSafe());
    }

    @Test
    public void AST_Comparison() throws InvalidAutomatonException {
        Assert.assertTrue((boolean)this.testAST("x=5;", "x= $?;"));
        Assert.assertFalse((boolean)this.testAST("x=5;", "x= 10;"));
        Assert.assertFalse((boolean)this.testAST("x=5;", "$? =10;"));
        Assert.assertTrue((boolean)this.testAST("x  = 5;", "$?=$?;"));
        Assert.assertFalse((boolean)this.testAST("a = 5;", "b    = 5;"));
        Assert.assertFalse((boolean)this.testAST("init();", "init($1);"));
        Assert.assertTrue((boolean)this.testAST("init(a, b);", "init($?, b);"));
        Assert.assertFalse((boolean)this.testAST("init(a, b);", "init($?, c);"));
        Assert.assertTrue((boolean)this.testAST("x = 5;", "x=$?"));
        Assert.assertTrue((boolean)this.testAST("x = 5", "x=$?;"));
        Assert.assertTrue((boolean)this.testAST("f();", "f($?);"));
        Assert.assertTrue((boolean)this.testAST("f(x);", "f($?);"));
        Assert.assertTrue((boolean)this.testAST("f(x, y);", "f($?);"));
        Assert.assertFalse((boolean)this.testAST("f(x);", "f(x, $?);"));
        Assert.assertTrue((boolean)this.testAST("f(x, y);", "f(x, $?);"));
        Assert.assertFalse((boolean)this.testAST("f(x, y, z);", "f(x, $?);"));
    }

    private boolean testAST(String src, String pattern) throws InvalidAutomatonException {
        AutomatonExpressionArguments args = new AutomatonExpressionArguments(null, null, null, null);
        IASTStatement sourceAST = AutomatonASTComparator.generateSourceAST(src);
        AutomatonASTComparator.ASTMatcher patternAST = AutomatonASTComparator.generatePatternAST(pattern);
        return patternAST.matches(sourceAST, args);
    }

    private TestResults run(Map<String, String> pProperties, String pSourceCodeFilePath) throws Exception {
        Configuration config = Configuration.builder().setOptions(pProperties).build();
        LogManager.StringHandler stringLogHandler = new LogManager.StringHandler();
        LogManager logger = new LogManager(config, (Handler)stringLogHandler);
        CPAchecker cpaChecker = new CPAchecker(config, logger);
        CPAcheckerResult results = cpaChecker.run(pSourceCodeFilePath);
        return new TestResults(stringLogHandler.getLog(), results);
    }

    private static class TestResults {
        private String log;
        private CPAcheckerResult checkerResult;

        public TestResults(String pLog, CPAcheckerResult pCheckerResult) {
            this.log = pLog;
            this.checkerResult = pCheckerResult;
        }

        public String getLog() {
            return this.log;
        }

        public CPAcheckerResult getCheckerResult() {
            return this.checkerResult;
        }

        boolean logContains(String pattern) {
            return this.log.contains(pattern);
        }

        boolean isSafe() {
            return this.checkerResult.getResult().equals((Object)CPAcheckerResult.Result.SAFE);
        }

        boolean isUnsafe() {
            return this.checkerResult.getResult().equals((Object)CPAcheckerResult.Result.UNSAFE);
        }

        public String toString() {
            return this.log;
        }
    }
}

