/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.automaton;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.Timer;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonExpression;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonExpressionArguments;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonInternalState;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonState;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonTransition;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonVariable;
import org.sosy_lab.cpachecker.cpa.automaton.ControlAutomatonCPA;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;

class AutomatonTransferRelation
implements TransferRelation {
    private final ControlAutomatonCPA cpa;
    private final LogManager logger;
    Timer totalPostTime = new Timer();
    Timer matchTime = new Timer();
    Timer assertionsTime = new Timer();
    Timer actionTime = new Timer();
    Timer totalStrengthenTime = new Timer();

    public AutomatonTransferRelation(ControlAutomatonCPA pCpa, LogManager pLogger) {
        this.cpa = pCpa;
        this.logger = pLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<? extends AbstractElement> getAbstractSuccessors(AbstractElement pElement, Precision pPrecision, CFAEdge pCfaEdge) throws CPATransferException {
        Preconditions.checkArgument((boolean)(pElement instanceof AutomatonState));
        this.totalPostTime.start();
        try {
            if (pElement instanceof AutomatonState.AutomatonUnknownState) {
                AutomatonState top = this.cpa.getTopState();
                Set<AutomatonState> set = Collections.singleton(top);
                return set;
            }
            if (!(pElement instanceof AutomatonState)) {
                throw new IllegalArgumentException("Cannot getAbstractSuccessor for non-AutomatonState AbstractElements.");
            }
            AutomatonState lCurrentAutomatonState = (AutomatonState)pElement;
            Collection<? extends AbstractElement> collection = this.getFollowStates(lCurrentAutomatonState, null, pCfaEdge, false);
            return collection;
        }
        finally {
            this.totalPostTime.stop();
        }
    }

    private Collection<? extends AbstractElement> getFollowStates(AutomatonState state, List<AbstractElement> otherElements, CFAEdge edge, boolean strengthen) throws CPATransferException {
        Preconditions.checkArgument((!(state instanceof AutomatonState.AutomatonUnknownState) ? 1 : 0) != 0);
        if (state == this.cpa.getBottomState()) {
            return Collections.emptySet();
        }
        if (state.getInternalState().getTransitions().isEmpty()) {
            return Collections.singleton(state);
        }
        HashSet<AutomatonState> lSuccessors = new HashSet<AutomatonState>(2);
        AutomatonExpressionArguments exprArgs = new AutomatonExpressionArguments(state.getVars(), otherElements, edge, this.logger);
        boolean edgeMatched = false;
        boolean nonDetState = state.getInternalState().isNonDetState();
        ArrayList<Pair> transitionsToBeTaken = new ArrayList<Pair>(2);
        for (AutomatonTransition t : state.getInternalState().getTransitions()) {
            exprArgs.clearTransitionVariables();
            this.matchTime.start();
            AutomatonExpression.ResultValue<Boolean> match = t.match(exprArgs);
            this.matchTime.stop();
            if (match.canNotEvaluate()) {
                if (strengthen) {
                    this.logger.log(Level.INFO, new Object[]{match.getFailureMessage() + " IN " + match.getFailureOrigin()});
                }
                return Collections.singleton(new AutomatonState.AutomatonUnknownState(state));
            }
            if (!match.getValue().booleanValue()) continue;
            edgeMatched = true;
            this.assertionsTime.start();
            AutomatonExpression.ResultValue<Boolean> assertionsHold = t.assertionsHold(exprArgs);
            this.assertionsTime.stop();
            if (assertionsHold.canNotEvaluate()) {
                if (strengthen) {
                    this.logger.log(Level.INFO, new Object[]{match.getFailureMessage() + " IN " + match.getFailureOrigin()});
                }
                return Collections.singleton(new AutomatonState.AutomatonUnknownState(state));
            }
            if (assertionsHold.getValue().booleanValue()) {
                if (!t.canExecuteActionsOn(exprArgs)) {
                    return Collections.singleton(new AutomatonState.AutomatonUnknownState(state));
                }
                ImmutableMap transitionVariables = ImmutableMap.copyOf(exprArgs.getTransitionVariables());
                transitionsToBeTaken.add(Pair.of((Object)t, (Object)transitionVariables));
            } else {
                AutomatonState errorState = AutomatonState.automatonStateFactory(Collections.<String, AutomatonVariable>emptyMap(), AutomatonInternalState.ERROR, this.cpa);
                this.logger.log(Level.INFO, new Object[]{"Automaton going to ErrorState on edge \"" + edge.getDescription() + "\""});
                lSuccessors.add(errorState);
            }
            if (nonDetState) continue;
            break;
        }
        if (edgeMatched) {
            for (Pair pair : transitionsToBeTaken) {
                AutomatonTransition t = (AutomatonTransition)pair.getFirst();
                Map transitionVariables = (Map)pair.getSecond();
                this.actionTime.start();
                Map<String, AutomatonVariable> newVars = AutomatonTransferRelation.deepCloneVars(state.getVars());
                exprArgs.setAutomatonVariables(newVars);
                exprArgs.putTransitionVariables(transitionVariables);
                t.executeActions(exprArgs);
                this.actionTime.stop();
                AutomatonState lSuccessor = AutomatonState.automatonStateFactory(newVars, t.getFollowState(), this.cpa);
                if (lSuccessor instanceof AutomatonState.BOTTOM) continue;
                lSuccessors.add(lSuccessor);
            }
            return lSuccessors;
        }
        return Collections.singleton(state);
    }

    private static Map<String, AutomatonVariable> deepCloneVars(Map<String, AutomatonVariable> pOld) {
        HashMap<String, AutomatonVariable> result = new HashMap<String, AutomatonVariable>(pOld.size());
        for (Map.Entry<String, AutomatonVariable> e : pOld.entrySet()) {
            result.put(e.getKey(), e.getValue().clone());
        }
        return result;
    }

    @Override
    public Collection<? extends AbstractElement> strengthen(AbstractElement pElement, List<AbstractElement> pOtherElements, CFAEdge pCfaEdge, Precision pPrecision) throws CPATransferException {
        if (!(pElement instanceof AutomatonState.AutomatonUnknownState)) {
            return null;
        }
        this.totalStrengthenTime.start();
        AutomatonState.AutomatonUnknownState lUnknownState = (AutomatonState.AutomatonUnknownState)pElement;
        Collection<? extends AbstractElement> lSuccessors = this.getFollowStates(lUnknownState.getPreviousState(), pOtherElements, pCfaEdge, true);
        this.totalStrengthenTime.stop();
        for (AbstractElement abstractElement : lSuccessors) {
            if (!(abstractElement instanceof AutomatonState.AutomatonUnknownState)) continue;
            throw new CPATransferException("Automaton transition could not be matched against CFA edge");
        }
        return lSuccessors;
    }
}

