/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.automaton;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.BreakOnTargetsPrecisionAdjustment;
import org.sosy_lab.cpachecker.core.defaults.FlatLatticeDomain;
import org.sosy_lab.cpachecker.core.defaults.MergeSepOperator;
import org.sosy_lab.cpachecker.core.defaults.NoOpReducer;
import org.sosy_lab.cpachecker.core.defaults.SingletonPrecision;
import org.sosy_lab.cpachecker.core.defaults.StaticPrecisionAdjustment;
import org.sosy_lab.cpachecker.core.defaults.StopSepOperator;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysisWithABM;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.ProofChecker;
import org.sosy_lab.cpachecker.core.interfaces.Reducer;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.cpa.automaton.Automaton;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonParser;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonState;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonStatistics;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonTransferRelation;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.globalinfo.GlobalInfo;

@Options(prefix="cpa.automaton")
public class ControlAutomatonCPA
implements ConfigurableProgramAnalysis,
StatisticsProvider,
ConfigurableProgramAnalysisWithABM,
ProofChecker {
    @Option(name="dotExport", description="export automaton to file")
    private boolean export = false;
    @Option(name="dotExportFile", description="file for saving the automaton in DOT format (%s will be replaced with automaton name)")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private File exportFile = new File("%s.dot");
    @Option(required=false, description="file with automaton specification for ObserverAutomatonCPA and ControlAutomatonCPA")
    @FileOption(value=FileOption.Type.OPTIONAL_INPUT_FILE)
    private File inputFile = null;
    @Option(description="signal the analysis to break in case of reached error state")
    private boolean breakOnTargetState = true;
    private final Automaton automaton;
    private final AutomatonState topState = new AutomatonState.TOP(this);
    private final AutomatonState bottomState = new AutomatonState.BOTTOM(this);
    private final AbstractDomain automatonDomain = new FlatLatticeDomain(this.topState);
    private final StopOperator stopOperator = new StopSepOperator(this.automatonDomain);
    private final AutomatonTransferRelation transferRelation;
    private final PrecisionAdjustment precisionAdjustment;
    private final Statistics stats = new AutomatonStatistics(this);

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(ControlAutomatonCPA.class);
    }

    protected ControlAutomatonCPA(@AutomaticCPAFactory.Optional Automaton pAutomaton, Configuration config, LogManager logger) throws InvalidConfigurationException {
        config.inject((Object)this, ControlAutomatonCPA.class);
        this.transferRelation = new AutomatonTransferRelation(this, logger);
        PrecisionAdjustment precisionAdjustment = this.precisionAdjustment = this.breakOnTargetState ? BreakOnTargetsPrecisionAdjustment.getInstance() : StaticPrecisionAdjustment.getInstance();
        if (pAutomaton != null) {
            this.automaton = pAutomaton;
        } else {
            if (this.inputFile == null) {
                throw new InvalidConfigurationException("Explicitly specified automaton CPA needs option cpa.automaton.inputFile!");
            }
            List<Automaton> lst = AutomatonParser.parseAutomatonFile(this.inputFile, config, logger);
            if (lst.isEmpty()) {
                throw new InvalidConfigurationException("Could not find automata in the file " + this.inputFile.getAbsolutePath());
            }
            if (lst.size() > 1) {
                throw new InvalidConfigurationException("Found " + lst.size() + " automata in the File " + this.inputFile.getAbsolutePath() + " The CPA can only handle ONE Automaton!");
            }
            this.automaton = lst.get(0);
        }
        logger.log(Level.FINEST, new Object[]{"Automaton", this.automaton.getName(), "loaded."});
        if (this.export && this.exportFile != null) {
            try {
                String fileName = String.format(this.exportFile.getAbsolutePath(), this.automaton.getName());
                this.automaton.writeDotFile(new PrintStream(fileName));
            }
            catch (FileNotFoundException e) {
                logger.log(Level.WARNING, new Object[]{"Could not create/write to the Automaton DOT file \"" + this.exportFile + "\""});
            }
        }
        GlobalInfo.getInstance().storeAutomaton(this.automaton);
    }

    Automaton getAutomaton() {
        return this.automaton;
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return this.automatonDomain;
    }

    @Override
    public AbstractElement getInitialElement(CFANode pNode) {
        return AutomatonState.automatonStateFactory(this.automaton.getInitialVariables(), this.automaton.getInitialState(), this);
    }

    @Override
    public Precision getInitialPrecision(CFANode pNode) {
        return SingletonPrecision.getInstance();
    }

    @Override
    public MergeOperator getMergeOperator() {
        return MergeSepOperator.getInstance();
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return this.precisionAdjustment;
    }

    @Override
    public StopOperator getStopOperator() {
        return this.stopOperator;
    }

    @Override
    public AutomatonTransferRelation getTransferRelation() {
        return this.transferRelation;
    }

    @Override
    public Reducer getReducer() {
        return NoOpReducer.getInstance();
    }

    public AutomatonState getBottomState() {
        return this.bottomState;
    }

    public AutomatonState getTopState() {
        return this.topState;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this.stats);
    }

    @Override
    public boolean areAbstractSuccessors(AbstractElement pElement, CFAEdge pCfaEdge, Collection<? extends AbstractElement> pSuccessors) throws CPATransferException, InterruptedException {
        return ((Object)pSuccessors).equals(this.getTransferRelation().getAbstractSuccessors(pElement, null, pCfaEdge));
    }

    @Override
    public boolean isCoveredBy(AbstractElement pElement, AbstractElement pOtherElement) throws CPAException {
        return this.getAbstractDomain().isLessOrEqual(pElement, pOtherElement);
    }
}

