/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.cache;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.Map;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.WrapperCPA;
import org.sosy_lab.cpachecker.cpa.cache.CacheMergeOperator;
import org.sosy_lab.cpachecker.cpa.cache.CachePrecisionAdjustment;
import org.sosy_lab.cpachecker.cpa.cache.CacheTransferRelation;

public class CacheCPA
implements ConfigurableProgramAnalysis,
WrapperCPA {
    private final ConfigurableProgramAnalysis mCachedCPA;
    private final Map<CFANode, AbstractElement> mInitialElementsCache;
    private final Map<CFANode, Precision> mInitialPrecisionsCache;
    private final CacheTransferRelation mCacheTransferRelation;
    private final CachePrecisionAdjustment mCachePrecisionAdjustment;
    private final CacheMergeOperator mCacheMergeOperator;

    public CacheCPA(ConfigurableProgramAnalysis pCachedCPA) {
        this.mCachedCPA = pCachedCPA;
        this.mInitialElementsCache = new HashMap<CFANode, AbstractElement>();
        this.mInitialPrecisionsCache = new HashMap<CFANode, Precision>();
        this.mCacheTransferRelation = new CacheTransferRelation(this.mCachedCPA.getTransferRelation());
        this.mCachePrecisionAdjustment = new CachePrecisionAdjustment(this.mCachedCPA.getPrecisionAdjustment());
        this.mCacheMergeOperator = new CacheMergeOperator(this.mCachedCPA.getMergeOperator());
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return this.mCachedCPA.getAbstractDomain();
    }

    @Override
    public TransferRelation getTransferRelation() {
        return this.mCacheTransferRelation;
    }

    @Override
    public MergeOperator getMergeOperator() {
        return this.mCacheMergeOperator;
    }

    @Override
    public StopOperator getStopOperator() {
        return this.mCachedCPA.getStopOperator();
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return this.mCachePrecisionAdjustment;
    }

    @Override
    public AbstractElement getInitialElement(CFANode pNode) {
        AbstractElement lInitialElement = this.mInitialElementsCache.get(pNode);
        if (lInitialElement == null) {
            lInitialElement = this.mCachedCPA.getInitialElement(pNode);
            this.mInitialElementsCache.put(pNode, lInitialElement);
        }
        return lInitialElement;
    }

    @Override
    public Precision getInitialPrecision(CFANode pNode) {
        Precision lInitialPrecision = this.mInitialPrecisionsCache.get(pNode);
        if (lInitialPrecision == null) {
            lInitialPrecision = this.mCachedCPA.getInitialPrecision(pNode);
            this.mInitialPrecisionsCache.put(pNode, lInitialPrecision);
        }
        return lInitialPrecision;
    }

    @Override
    public <T extends ConfigurableProgramAnalysis> T retrieveWrappedCpa(Class<T> pType) {
        if (pType.isAssignableFrom(this.getClass())) {
            return (T)((ConfigurableProgramAnalysis)pType.cast(this));
        }
        if (pType.isAssignableFrom(this.mCachedCPA.getClass())) {
            return (T)((ConfigurableProgramAnalysis)pType.cast(this.mCachedCPA));
        }
        if (this.mCachedCPA instanceof WrapperCPA) {
            return ((WrapperCPA)((Object)this.mCachedCPA)).retrieveWrappedCpa(pType);
        }
        return null;
    }

    public ImmutableList<? extends ConfigurableProgramAnalysis> getWrappedCPAs() {
        return ImmutableList.of((Object)this.mCachedCPA);
    }
}

