/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.cache;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;

public class CacheTransferRelation
implements TransferRelation {
    private final TransferRelation mCachedTransferRelation;
    private Map<Precision, Map<CFAEdge, Map<AbstractElement, Collection<? extends AbstractElement>>>> mSuccessorsCache;
    private int lCacheMisses = 0;
    private int lCacheHits = 0;

    public CacheTransferRelation(TransferRelation pCachedTransferRelation) {
        this.mCachedTransferRelation = pCachedTransferRelation;
        this.mSuccessorsCache = new HashMap<Precision, Map<CFAEdge, Map<AbstractElement, Collection<? extends AbstractElement>>>>();
    }

    @Override
    public Collection<? extends AbstractElement> getAbstractSuccessors(AbstractElement pElement, Precision pPrecision, CFAEdge pCfaEdge) throws CPATransferException, InterruptedException {
        Collection<? extends AbstractElement> lSuccessors;
        Map<AbstractElement, Collection<? extends AbstractElement>> lLevel2Cache;
        Map<CFAEdge, Map<AbstractElement, Collection<? extends AbstractElement>>> lLevel1Cache = this.mSuccessorsCache.get(pPrecision);
        if (lLevel1Cache == null) {
            lLevel1Cache = new HashMap<CFAEdge, Map<AbstractElement, Collection<? extends AbstractElement>>>();
            this.mSuccessorsCache.put(pPrecision, lLevel1Cache);
        }
        if ((lLevel2Cache = lLevel1Cache.get(pCfaEdge)) == null) {
            lLevel2Cache = new HashMap<AbstractElement, Collection<? extends AbstractElement>>();
            lLevel1Cache.put(pCfaEdge, lLevel2Cache);
        }
        if ((lSuccessors = lLevel2Cache.get(pElement)) == null) {
            lSuccessors = this.mCachedTransferRelation.getAbstractSuccessors(pElement, pPrecision, pCfaEdge);
            lLevel2Cache.put(pElement, lSuccessors);
            ++this.lCacheMisses;
        } else {
            ++this.lCacheHits;
        }
        if ((this.lCacheMisses + this.lCacheHits) % 100 == 0) {
            System.out.println("Misses: " + this.lCacheMisses + ", hits: " + this.lCacheHits + ", sum: " + (this.lCacheMisses + this.lCacheHits));
        }
        return lSuccessors;
    }

    @Override
    public Collection<? extends AbstractElement> strengthen(AbstractElement pElement, List<AbstractElement> pOtherElements, CFAEdge pCfaEdge, Precision pPrecision) throws CPATransferException, InterruptedException {
        return this.mCachedTransferRelation.strengthen(pElement, pOtherElements, pCfaEdge, pPrecision);
    }
}

