/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.callstack;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.AbstractQueryableElement;
import org.sosy_lab.cpachecker.core.interfaces.Partitionable;
import org.sosy_lab.cpachecker.exceptions.InvalidQueryException;
import org.sosy_lab.cpachecker.util.globalinfo.GlobalInfo;

public final class CallstackElement
implements AbstractElement,
Partitionable,
AbstractQueryableElement,
Serializable {
    private static final long serialVersionUID = 3629687385150064994L;
    private final CallstackElement previousElement;
    private final String currentFunction;
    private transient CFANode callerNode;
    private final int depth;

    CallstackElement(CallstackElement previousElement, String function, CFANode callerNode) {
        this.previousElement = previousElement;
        this.currentFunction = (String)Preconditions.checkNotNull((Object)function);
        this.callerNode = (CFANode)Preconditions.checkNotNull((Object)callerNode);
        this.depth = previousElement == null ? 1 : previousElement.getDepth() + 1;
    }

    public CallstackElement getPreviousElement() {
        return this.previousElement;
    }

    public String getCurrentFunction() {
        return this.currentFunction;
    }

    public CFANode getCallNode() {
        return this.callerNode;
    }

    public int getDepth() {
        return this.depth;
    }

    @Override
    public Object getPartitionKey() {
        return this;
    }

    public String toString() {
        return "Function " + this.getCurrentFunction() + " called from node " + this.getCallNode() + ", stack depth " + this.getDepth() + " [" + Integer.toHexString(super.hashCode()) + "]";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (CallstackElement.class != obj.getClass()) {
            return false;
        }
        CallstackElement other = (CallstackElement)obj;
        return this.previousElement == other.previousElement && this.currentFunction.equals(other.currentFunction) && this.callerNode.equals(other.callerNode);
    }

    public int hashCode() {
        return (this.callerNode.hashCode() * 31 + System.identityHashCode(this.previousElement)) * 17 + this.currentFunction.hashCode();
    }

    @Override
    public String getCPAName() {
        return "Callstack";
    }

    @Override
    public boolean checkProperty(String pProperty) throws InvalidQueryException {
        return false;
    }

    @Override
    public Object evaluateProperty(String pProperty) throws InvalidQueryException {
        if (pProperty.compareToIgnoreCase("caller") == 0) {
            if (this.callerNode != null) {
                return this.callerNode.getFunctionName();
            }
            return "";
        }
        throw new InvalidQueryException(String.format("Evaluating %s not supported by %s", pProperty, this.getClass().getCanonicalName()));
    }

    @Override
    public void modifyProperty(String pModification) throws InvalidQueryException {
        throw new InvalidQueryException("modifyProperty not implemented by " + this.getClass().getCanonicalName());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.callerNode.getNodeNumber());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int nodeNumber = in.readInt();
        this.callerNode = GlobalInfo.getInstance().getCFAInfo().getNodeByNodeNumber(nodeNumber);
    }
}

