/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.callstack;

import org.sosy_lab.cpachecker.cfa.blocks.Block;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Reducer;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackElement;

public class CallstackReducer
implements Reducer {
    @Override
    public AbstractElement getVariableReducedElement(AbstractElement pExpandedElement, Block pContext, CFANode callNode) {
        CallstackElement element = (CallstackElement)pExpandedElement;
        return this.copyCallstackUpToCallNode(element, callNode);
    }

    private CallstackElement copyCallstackUpToCallNode(CallstackElement element, CFANode callNode) {
        if (element.getCurrentFunction().equals(callNode.getFunctionName())) {
            return new CallstackElement(null, element.getCurrentFunction(), callNode);
        }
        assert (element.getPreviousElement() != null);
        CallstackElement recursiveResult = this.copyCallstackUpToCallNode(element.getPreviousElement(), callNode);
        return new CallstackElement(recursiveResult, element.getCurrentFunction(), element.getCallNode());
    }

    @Override
    public AbstractElement getVariableExpandedElement(AbstractElement pRootElement, Block pReducedContext, AbstractElement pReducedElement) {
        CallstackElement rootElement = (CallstackElement)pRootElement;
        CallstackElement reducedElement = (CallstackElement)pReducedElement;
        return this.copyCallstackExceptLast(rootElement, reducedElement);
    }

    private CallstackElement copyCallstackExceptLast(CallstackElement target, CallstackElement source) {
        if (source.getDepth() == 1) {
            assert (source.getPreviousElement() == null);
            assert (source.getCurrentFunction().equals(target.getCurrentFunction()));
            return target;
        }
        CallstackElement recursiveResult = this.copyCallstackExceptLast(target, source.getPreviousElement());
        return new CallstackElement(recursiveResult, source.getCurrentFunction(), source.getCallNode());
    }

    private static boolean isEqual(CallstackElement reducedTargetElement, CallstackElement candidateElement) {
        if (reducedTargetElement.getDepth() != candidateElement.getDepth()) {
            return false;
        }
        while (reducedTargetElement != null) {
            if (!reducedTargetElement.getCallNode().equals(candidateElement.getCallNode()) || !reducedTargetElement.getCurrentFunction().equals(candidateElement.getCurrentFunction())) {
                return false;
            }
            reducedTargetElement = reducedTargetElement.getPreviousElement();
            candidateElement = candidateElement.getPreviousElement();
        }
        return true;
    }

    @Override
    public Object getHashCodeForElement(AbstractElement pElementKey, Precision pPrecisionKey) {
        return new CallstackElementWithEquals((CallstackElement)pElementKey);
    }

    @Override
    public Precision getVariableReducedPrecision(Precision pPrecision, Block pContext) {
        return pPrecision;
    }

    @Override
    public Precision getVariableExpandedPrecision(Precision rootPrecision, Block rootContext, Precision reducedPrecision) {
        return reducedPrecision;
    }

    @Override
    public int measurePrecisionDifference(Precision pPrecision, Precision pOtherPrecision) {
        return 0;
    }

    private static class CallstackElementWithEquals {
        private final CallstackElement element;

        public CallstackElementWithEquals(CallstackElement pElement) {
            this.element = pElement;
        }

        public boolean equals(Object other) {
            if (!(other instanceof CallstackElementWithEquals)) {
                return false;
            }
            return CallstackReducer.isEqual(this.element, ((CallstackElementWithEquals)other).element);
        }

        public int hashCode() {
            return (this.element.getDepth() * 17 + this.element.getCurrentFunction().hashCode()) * 31 + this.element.getCallNode().hashCode();
        }
    }
}

