/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.callstack;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionReturnEdge;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackElement;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnsupportedCCodeException;

public class CallstackTransferRelation
implements TransferRelation {
    @Override
    public Collection<? extends AbstractElement> getAbstractSuccessors(AbstractElement pElement, Precision pPrecision, CFAEdge pCfaEdge) throws CPATransferException {
        switch (pCfaEdge.getEdgeType()) {
            case FunctionCallEdge: {
                FunctionCallEdge cfaEdge = (FunctionCallEdge)pCfaEdge;
                CallstackElement element = (CallstackElement)pElement;
                String functionName = cfaEdge.getSuccessor().getFunctionName();
                CFANode callNode = cfaEdge.getPredecessor();
                for (CallstackElement e = element; e != null; e = e.getPreviousElement()) {
                    if (!e.getCurrentFunction().equals(functionName)) continue;
                    throw new UnsupportedCCodeException("recursion", pCfaEdge);
                }
                return Collections.singleton(new CallstackElement(element, functionName, callNode));
            }
            case FunctionReturnEdge: {
                FunctionReturnEdge cfaEdge = (FunctionReturnEdge)pCfaEdge;
                CallstackElement element = (CallstackElement)pElement;
                String calledFunction = cfaEdge.getPredecessor().getFunctionName();
                String callerFunction = cfaEdge.getSuccessor().getFunctionName();
                CFANode returnNode = cfaEdge.getSuccessor();
                CFANode callNode = returnNode.getEnteringSummaryEdge().getPredecessor();
                assert (calledFunction.equals(element.getCurrentFunction()));
                if (!callNode.equals(element.getCallNode())) {
                    return Collections.emptySet();
                }
                CallstackElement returnElement = element.getPreviousElement();
                assert (callerFunction.equals(returnElement.getCurrentFunction()));
                return Collections.singleton(returnElement);
            }
        }
        return Collections.singleton(pElement);
    }

    @Override
    public Collection<? extends AbstractElement> strengthen(AbstractElement pElement, List<AbstractElement> pOtherElements, CFAEdge pCfaEdge, Precision pPrecision) {
        return null;
    }
}

