/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.cfapath;

import java.util.Iterator;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cpa.cfapath.CFAPathElement;

public class CFAPathStandardElement
implements CFAPathElement,
Iterable<CFAEdge> {
    private static final CFAPathStandardElement sEmptyPath = new CFAPathStandardElement();
    private final CFAPathStandardElement mPredecessor;
    private final CFAEdge mCFAEdge;
    private final int mLength;

    public static CFAPathStandardElement getEmptyPath() {
        return sEmptyPath;
    }

    private CFAPathStandardElement() {
        this.mPredecessor = null;
        this.mCFAEdge = null;
        this.mLength = 0;
    }

    public CFAPathStandardElement(CFAPathStandardElement pPredecessor, CFAEdge pCFAEdge) {
        if (pPredecessor == null) {
            throw new IllegalArgumentException();
        }
        if (pCFAEdge == null) {
            throw new IllegalArgumentException();
        }
        this.mPredecessor = pPredecessor;
        this.mCFAEdge = pCFAEdge;
        this.mLength = pPredecessor.getLength() + 1;
    }

    public int getLength() {
        return this.mLength;
    }

    public CFAEdge get(int lIndex) {
        if (lIndex >= this.mLength || lIndex < 0) {
            throw new IllegalArgumentException();
        }
        if (lIndex + 1 == this.mLength) {
            return this.mCFAEdge;
        }
        return this.mPredecessor.get(lIndex);
    }

    @Override
    public Iterator<CFAEdge> iterator() {
        return new CFAEdgeIterator(this);
    }

    public CFAEdge[] toArray() {
        CFAEdge[] lPath = new CFAEdge[this.mLength];
        CFAPathStandardElement lElement = this;
        for (int lIndex = this.mLength - 1; lIndex >= 0; --lIndex) {
            lPath[lIndex] = lElement.mCFAEdge;
            lElement = lElement.mPredecessor;
        }
        return lPath;
    }

    public String toString() {
        if (this.getLength() == 0) {
            return "<>";
        }
        if (this.getLength() == 1) {
            return "< " + ((Object)this.mCFAEdge).toString() + " >";
        }
        return "< ... " + ((Object)this.mCFAEdge).toString() + " >";
    }

    private static class CFAEdgeIterator
    implements Iterator<CFAEdge> {
        private CFAPathStandardElement mCurrentElement;

        public CFAEdgeIterator(CFAPathStandardElement pLastElement) {
            this.mCurrentElement = pLastElement;
        }

        @Override
        public boolean hasNext() {
            return this.mCurrentElement != sEmptyPath;
        }

        @Override
        public CFAEdge next() {
            CFAEdge lNextCFAEdge = this.mCurrentElement.mCFAEdge;
            this.mCurrentElement = this.mCurrentElement.mPredecessor;
            return lNextCFAEdge;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

