/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.composite;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.core.defaults.AbstractCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.MergeSepOperator;
import org.sosy_lab.cpachecker.core.defaults.SimplePrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysisWithABM;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.ProofChecker;
import org.sosy_lab.cpachecker.core.interfaces.Reducer;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.WrapperCPA;
import org.sosy_lab.cpachecker.cpa.composite.CompositeDomain;
import org.sosy_lab.cpachecker.cpa.composite.CompositeElement;
import org.sosy_lab.cpachecker.cpa.composite.CompositeMergeAgreeOperator;
import org.sosy_lab.cpachecker.cpa.composite.CompositeMergePlainOperator;
import org.sosy_lab.cpachecker.cpa.composite.CompositePrecision;
import org.sosy_lab.cpachecker.cpa.composite.CompositePrecisionAdjustment;
import org.sosy_lab.cpachecker.cpa.composite.CompositeReducer;
import org.sosy_lab.cpachecker.cpa.composite.CompositeSimplePrecisionAdjustment;
import org.sosy_lab.cpachecker.cpa.composite.CompositeStopOperator;
import org.sosy_lab.cpachecker.cpa.composite.CompositeTransferRelation;
import org.sosy_lab.cpachecker.cpa.explicit.OmniscientCompositePrecisionAdjustment;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;

public class CompositeCPA
implements ConfigurableProgramAnalysis,
StatisticsProvider,
WrapperCPA,
ConfigurableProgramAnalysisWithABM,
ProofChecker {
    private final AbstractDomain abstractDomain;
    private final CompositeTransferRelation transferRelation;
    private final MergeOperator mergeOperator;
    private final CompositeStopOperator stopOperator;
    private final PrecisionAdjustment precisionAdjustment;
    private final Reducer reducer;
    private final ImmutableList<ConfigurableProgramAnalysis> cpas;

    public static CPAFactory factory() {
        return new CompositeCPAFactory();
    }

    protected CompositeCPA(AbstractDomain abstractDomain, CompositeTransferRelation transferRelation, MergeOperator mergeOperator, CompositeStopOperator stopOperator, PrecisionAdjustment precisionAdjustment, ImmutableList<ConfigurableProgramAnalysis> cpas) {
        this.abstractDomain = abstractDomain;
        this.transferRelation = transferRelation;
        this.mergeOperator = mergeOperator;
        this.stopOperator = stopOperator;
        this.precisionAdjustment = precisionAdjustment;
        this.cpas = cpas;
        ArrayList<Reducer> wrappedReducers = new ArrayList<Reducer>();
        for (ConfigurableProgramAnalysis cpa : cpas) {
            if (cpa instanceof ConfigurableProgramAnalysisWithABM) {
                wrappedReducers.add(((ConfigurableProgramAnalysisWithABM)cpa).getReducer());
                continue;
            }
            wrappedReducers.clear();
            break;
        }
        this.reducer = !wrappedReducers.isEmpty() ? new CompositeReducer(wrappedReducers) : null;
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return this.abstractDomain;
    }

    @Override
    public TransferRelation getTransferRelation() {
        return this.transferRelation;
    }

    @Override
    public MergeOperator getMergeOperator() {
        return this.mergeOperator;
    }

    @Override
    public StopOperator getStopOperator() {
        return this.stopOperator;
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return this.precisionAdjustment;
    }

    @Override
    public Reducer getReducer() {
        return this.reducer;
    }

    @Override
    public AbstractElement getInitialElement(CFANode node) {
        Preconditions.checkNotNull((Object)node);
        ImmutableList.Builder initialElements = ImmutableList.builder();
        for (ConfigurableProgramAnalysis sp : this.cpas) {
            initialElements.add((Object)sp.getInitialElement(node));
        }
        return new CompositeElement((List<AbstractElement>)initialElements.build());
    }

    @Override
    public Precision getInitialPrecision(CFANode node) {
        Preconditions.checkNotNull((Object)node);
        ImmutableList.Builder initialPrecisions = ImmutableList.builder();
        for (ConfigurableProgramAnalysis sp : this.cpas) {
            initialPrecisions.add((Object)sp.getInitialPrecision(node));
        }
        return new CompositePrecision((List<Precision>)initialPrecisions.build());
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        for (ConfigurableProgramAnalysis cpa : this.cpas) {
            if (!(cpa instanceof StatisticsProvider)) continue;
            ((StatisticsProvider)((Object)cpa)).collectStatistics(pStatsCollection);
        }
        if (this.precisionAdjustment instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)this.precisionAdjustment)).collectStatistics(pStatsCollection);
        }
    }

    @Override
    public <T extends ConfigurableProgramAnalysis> T retrieveWrappedCpa(Class<T> pType) {
        if (pType.isAssignableFrom(this.getClass())) {
            return (T)((ConfigurableProgramAnalysis)pType.cast(this));
        }
        for (ConfigurableProgramAnalysis cpa : this.cpas) {
            T result;
            if (pType.isAssignableFrom(cpa.getClass())) {
                return (T)((ConfigurableProgramAnalysis)pType.cast(cpa));
            }
            if (!(cpa instanceof WrapperCPA) || (result = ((WrapperCPA)((Object)cpa)).retrieveWrappedCpa(pType)) == null) continue;
            return result;
        }
        return null;
    }

    public ImmutableList<? extends ConfigurableProgramAnalysis> getWrappedCPAs() {
        return this.cpas;
    }

    @Override
    public boolean areAbstractSuccessors(AbstractElement pElement, CFAEdge pCfaEdge, Collection<? extends AbstractElement> pSuccessors) throws CPATransferException, InterruptedException {
        return this.transferRelation.areAbstractSuccessors(pElement, pCfaEdge, pSuccessors, (List<ConfigurableProgramAnalysis>)this.cpas);
    }

    @Override
    public boolean isCoveredBy(AbstractElement pElement, AbstractElement pOtherElement) throws CPAException {
        return this.stopOperator.isCoveredBy(pElement, pOtherElement, (List<ConfigurableProgramAnalysis>)this.cpas);
    }

    private static class CompositeCPAFactory
    extends AbstractCPAFactory {
        private ImmutableList<ConfigurableProgramAnalysis> cpas = null;

        private CompositeCPAFactory() {
        }

        @Override
        public ConfigurableProgramAnalysis createInstance() throws InvalidConfigurationException {
            MergeOperator compositeMerge;
            Preconditions.checkState((this.cpas != null ? 1 : 0) != 0, (Object)"CompositeCPA needs wrapped CPAs!");
            CompositeOptions options = new CompositeOptions();
            this.getConfiguration().inject((Object)options);
            ImmutableList.Builder domains = ImmutableList.builder();
            ImmutableList.Builder transferRelations = ImmutableList.builder();
            ImmutableList.Builder mergeOperators = ImmutableList.builder();
            ImmutableList.Builder stopOperators = ImmutableList.builder();
            ImmutableList.Builder precisionAdjustments = ImmutableList.builder();
            ImmutableList.Builder simplePrecisionAdjustments = ImmutableList.builder();
            boolean mergeSep = true;
            boolean simplePrec = true;
            for (ConfigurableProgramAnalysis sp : this.cpas) {
                domains.add((Object)sp.getAbstractDomain());
                transferRelations.add((Object)sp.getTransferRelation());
                stopOperators.add((Object)sp.getStopOperator());
                PrecisionAdjustment prec = sp.getPrecisionAdjustment();
                if (prec instanceof SimplePrecisionAdjustment) {
                    simplePrecisionAdjustments.add((Object)((SimplePrecisionAdjustment)prec));
                } else {
                    simplePrec = false;
                }
                precisionAdjustments.add((Object)prec);
                MergeOperator merge = sp.getMergeOperator();
                if (merge != MergeSepOperator.getInstance()) {
                    mergeSep = false;
                }
                mergeOperators.add((Object)merge);
            }
            ImmutableList stopOps = stopOperators.build();
            if (mergeSep) {
                compositeMerge = MergeSepOperator.getInstance();
            } else if (options.merge.equals("AGREE")) {
                compositeMerge = new CompositeMergeAgreeOperator((ImmutableList<MergeOperator>)mergeOperators.build(), (ImmutableList<StopOperator>)stopOps);
            } else if (options.merge.equals("PLAIN")) {
                compositeMerge = new CompositeMergePlainOperator((ImmutableList<MergeOperator>)mergeOperators.build());
            } else {
                throw new AssertionError();
            }
            CompositeDomain compositeDomain = new CompositeDomain((ImmutableList<AbstractDomain>)domains.build());
            CompositeTransferRelation compositeTransfer = new CompositeTransferRelation((ImmutableList<TransferRelation>)transferRelations.build());
            CompositeStopOperator compositeStop = new CompositeStopOperator((ImmutableList<StopOperator>)stopOps);
            PrecisionAdjustment compositePrecisionAdjustment = options.precAdjust.equals("IGNORANT") ? (simplePrec ? new CompositeSimplePrecisionAdjustment((ImmutableList<SimplePrecisionAdjustment>)simplePrecisionAdjustments.build()) : new CompositePrecisionAdjustment((ImmutableList<PrecisionAdjustment>)precisionAdjustments.build())) : new OmniscientCompositePrecisionAdjustment((ImmutableList<PrecisionAdjustment>)precisionAdjustments.build());
            return new CompositeCPA(compositeDomain, compositeTransfer, compositeMerge, compositeStop, compositePrecisionAdjustment, this.cpas);
        }

        @Override
        public CPAFactory setChild(ConfigurableProgramAnalysis pChild) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Use CompositeCPA to wrap several CPAs!");
        }

        @Override
        public CPAFactory setChildren(List<ConfigurableProgramAnalysis> pChildren) {
            Preconditions.checkNotNull(pChildren);
            Preconditions.checkArgument((!pChildren.isEmpty() ? 1 : 0) != 0);
            Preconditions.checkState((this.cpas == null ? 1 : 0) != 0);
            this.cpas = ImmutableList.copyOf(pChildren);
            return this;
        }
    }

    @Options(prefix="cpa.composite")
    private static class CompositeOptions {
        @Option(toUppercase=true, values={"PLAIN", "AGREE"}, description="which composite merge operator to use (plain or agree)\nBoth delegate to the component cpas, but agree only allows merging if all cpas agree on this. This is probably what you want.")
        private String merge = "AGREE";
        @Option(toUppercase=true, values={"IGNORANT", "OMNISCIENT"}, description="which precision adjustment strategy to use (ignorant or omniscient)\nWhile an ignorant strategy keeps the domain knowledge seperated, and delegates to the component precision adjustment operators, the omniscient strategy may operate on global knowledge.")
        private String precAdjust = "IGNORANT";

        private CompositeOptions() {
        }
    }
}

