/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.composite;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.cpa.composite.CompositeElement;
import org.sosy_lab.cpachecker.exceptions.CPAException;

public class CompositeDomain
implements AbstractDomain {
    private final ImmutableList<AbstractDomain> domains;

    public CompositeDomain(ImmutableList<AbstractDomain> domains) {
        this.domains = domains;
    }

    @Override
    public AbstractElement join(AbstractElement pElement1, AbstractElement pElement2) throws CPAException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isLessOrEqual(AbstractElement pElement1, AbstractElement pElement2) throws CPAException {
        CompositeElement comp1 = (CompositeElement)pElement1;
        CompositeElement comp2 = (CompositeElement)pElement2;
        Iterable comp1Elements = comp1.getWrappedElements();
        Iterable comp2Elements = comp2.getWrappedElements();
        Preconditions.checkState((comp1Elements.size() == comp2Elements.size() ? 1 : 0) != 0);
        Preconditions.checkState((comp1Elements.size() == this.domains.size() ? 1 : 0) != 0);
        for (int idx = 0; idx < comp1Elements.size(); ++idx) {
            AbstractDomain domain = (AbstractDomain)this.domains.get(idx);
            if (domain.isLessOrEqual((AbstractElement)comp1Elements.get(idx), (AbstractElement)comp2Elements.get(idx))) continue;
            return false;
        }
        return true;
    }
}

