/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.composite;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.AbstractWrapperElement;
import org.sosy_lab.cpachecker.core.interfaces.Partitionable;
import org.sosy_lab.cpachecker.core.interfaces.Targetable;

public class CompositeElement
implements AbstractWrapperElement,
Targetable,
Partitionable,
Serializable {
    private static final long serialVersionUID = -5143296331663510680L;
    private final ImmutableList<AbstractElement> elements;
    private transient Object partitionKey;

    public CompositeElement(List<AbstractElement> elements) {
        this.elements = ImmutableList.copyOf(elements);
    }

    public int getNumberofElements() {
        return this.elements.size();
    }

    @Override
    public boolean isTarget() {
        for (AbstractElement element : this.elements) {
            if (!(element instanceof Targetable) || !((Targetable)((Object)element)).isTarget()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        for (AbstractElement element : this.elements) {
            builder.append(element.getClass().getSimpleName());
            builder.append(": ");
            builder.append(element.toString());
            builder.append("\n ");
        }
        builder.replace(builder.length() - 1, builder.length(), ")");
        return builder.toString();
    }

    public AbstractElement get(int idx) {
        return (AbstractElement)this.elements.get(idx);
    }

    public List<AbstractElement> getWrappedElements() {
        return this.elements;
    }

    @Override
    public Object getPartitionKey() {
        if (this.partitionKey == null) {
            Object[] keys = new Object[this.elements.size()];
            int i = 0;
            for (AbstractElement element : this.elements) {
                if (element instanceof Partitionable) {
                    keys[i] = ((Partitionable)((Object)element)).getPartitionKey();
                }
                ++i;
            }
            this.partitionKey = new CompositePartitionKey(keys);
        }
        return this.partitionKey;
    }

    private static final class CompositePartitionKey {
        private final Object[] keys;

        private CompositePartitionKey(Object[] pElements) {
            this.keys = pElements;
        }

        public boolean equals(Object pObj) {
            if (this == pObj) {
                return true;
            }
            if (CompositePartitionKey.class != pObj.getClass()) {
                return false;
            }
            return Arrays.equals(this.keys, ((CompositePartitionKey)pObj).keys);
        }

        public int hashCode() {
            return Arrays.hashCode(this.keys);
        }

        public String toString() {
            return "[" + Joiner.on((String)", ").skipNulls().join(this.keys) + "]";
        }
    }
}

