/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.composite;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.cpa.composite.CompositeElement;
import org.sosy_lab.cpachecker.cpa.composite.CompositePrecision;
import org.sosy_lab.cpachecker.exceptions.CPAException;

public class CompositeMergeAgreeOperator
implements MergeOperator {
    private final ImmutableList<MergeOperator> mergeOperators;
    private final ImmutableList<StopOperator> stopOperators;

    public CompositeMergeAgreeOperator(ImmutableList<MergeOperator> mergeOperators, ImmutableList<StopOperator> stopOperators) {
        this.mergeOperators = mergeOperators;
        this.stopOperators = stopOperators;
    }

    @Override
    public AbstractElement merge(AbstractElement element1, AbstractElement element2, Precision precision) throws CPAException {
        CompositeElement comp1 = (CompositeElement)element1;
        CompositeElement comp2 = (CompositeElement)element2;
        CompositePrecision compositePrec = (CompositePrecision)precision;
        assert (comp1.getNumberofElements() == comp2.getNumberofElements());
        ImmutableList.Builder mergedElements = ImmutableList.builder();
        UnmodifiableIterator stopIter = this.stopOperators.iterator();
        Iterator iter1 = comp1.getWrappedElements().iterator();
        Iterator iter2 = comp2.getWrappedElements().iterator();
        Iterator<Precision> precIter = compositePrec.getPrecisions().iterator();
        boolean identicElements = true;
        for (MergeOperator mergeOp : this.mergeOperators) {
            AbstractElement merged;
            AbstractElement absElem1 = (AbstractElement)iter1.next();
            AbstractElement absElem2 = (AbstractElement)iter2.next();
            Precision prec = precIter.next();
            StopOperator stopOp = (StopOperator)stopIter.next();
            if (!stopOp.stop(absElem1, Collections.singleton(merged = mergeOp.merge(absElem1, absElem2, prec)), prec)) {
                return element2;
            }
            if (merged != absElem2) {
                identicElements = false;
            }
            mergedElements.add((Object)merged);
        }
        if (identicElements) {
            return element2;
        }
        return new CompositeElement((List<AbstractElement>)mergedElements.build());
    }
}

