/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.composite;

import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.composite.CompositeElement;
import org.sosy_lab.cpachecker.cpa.composite.CompositePrecision;
import org.sosy_lab.cpachecker.exceptions.CPAException;

public class CompositeMergePlainOperator
implements MergeOperator {
    private final ImmutableList<MergeOperator> mergeOperators;

    public CompositeMergePlainOperator(ImmutableList<MergeOperator> mergeOperators) {
        this.mergeOperators = mergeOperators;
    }

    @Override
    public AbstractElement merge(AbstractElement element1, AbstractElement element2, Precision precision) throws CPAException {
        CompositeElement comp1 = (CompositeElement)element1;
        CompositeElement comp2 = (CompositeElement)element2;
        CompositePrecision prec = (CompositePrecision)precision;
        assert (comp1.getNumberofElements() == comp2.getNumberofElements());
        ImmutableList.Builder mergedElements = ImmutableList.builder();
        Iterator iter1 = comp1.getWrappedElements().iterator();
        Iterator iter2 = comp2.getWrappedElements().iterator();
        Iterator<Precision> precIter = prec.getPrecisions().iterator();
        boolean identicElements = true;
        for (MergeOperator mergeOp : this.mergeOperators) {
            AbstractElement absElem2;
            AbstractElement absElem1;
            AbstractElement merged = mergeOp.merge(absElem1 = (AbstractElement)iter1.next(), absElem2 = (AbstractElement)iter2.next(), precIter.next());
            if (merged != absElem2) {
                identicElements = false;
            }
            mergedElements.add((Object)merged);
        }
        if (identicElements) {
            return element2;
        }
        return new CompositeElement((List<AbstractElement>)mergedElements.build());
    }
}

