/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.composite;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.WrapperPrecision;

public class CompositePrecision
implements WrapperPrecision {
    private final List<Precision> precisions;

    public CompositePrecision(List<Precision> precisions) {
        this.precisions = ImmutableList.copyOf(precisions);
    }

    public List<Precision> getPrecisions() {
        return this.precisions;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !(other instanceof CompositePrecision)) {
            return false;
        }
        return ((Object)this.precisions).equals(((CompositePrecision)other).precisions);
    }

    public int hashCode() {
        return ((Object)this.precisions).hashCode();
    }

    public Precision get(int idx) {
        return this.precisions.get(idx);
    }

    public String toString() {
        return this.precisions.toString();
    }

    @Override
    public <T extends Precision> T retrieveWrappedPrecision(Class<T> pType) {
        if (pType.isAssignableFrom(this.getClass())) {
            return (T)((Precision)pType.cast(this));
        }
        for (Precision precision : this.precisions) {
            T result;
            if (pType.isAssignableFrom(precision.getClass())) {
                return (T)((Precision)pType.cast(precision));
            }
            if (!(precision instanceof WrapperPrecision) || (result = ((WrapperPrecision)precision).retrieveWrappedPrecision(pType)) == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public Precision replaceWrappedPrecision(Precision newPrecision, Class<? extends Precision> replaceType) {
        assert (replaceType.isAssignableFrom(newPrecision.getClass()));
        if (replaceType.equals(CompositePrecision.class)) {
            return newPrecision;
        }
        ImmutableList.Builder newPrecisions = ImmutableList.builder();
        boolean changed = false;
        for (Precision precision : this.precisions) {
            if (replaceType.isAssignableFrom(precision.getClass())) {
                newPrecisions.add((Object)newPrecision);
                changed = true;
                continue;
            }
            if (precision instanceof WrapperPrecision) {
                Precision newWrappedPrecision = ((WrapperPrecision)precision).replaceWrappedPrecision(newPrecision, replaceType);
                if (newWrappedPrecision != null) {
                    newPrecisions.add((Object)newWrappedPrecision);
                    changed = true;
                    continue;
                }
                newPrecisions.add((Object)precision);
                continue;
            }
            newPrecisions.add((Object)precision);
        }
        return changed ? new CompositePrecision((List<Precision>)newPrecisions.build()) : null;
    }
}

