/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.composite;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sosy_lab.common.Triple;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSetView;
import org.sosy_lab.cpachecker.cpa.composite.CompositeElement;
import org.sosy_lab.cpachecker.cpa.composite.CompositePrecision;
import org.sosy_lab.cpachecker.exceptions.CPAException;

public class CompositePrecisionAdjustment
implements PrecisionAdjustment {
    protected final ImmutableList<PrecisionAdjustment> precisionAdjustments;
    protected final ImmutableList<ElementProjectionFunction> elementProjectionFunctions;
    protected final ImmutableList<PrecisionProjectionFunction> precisionProjectionFunctions;

    public CompositePrecisionAdjustment(ImmutableList<PrecisionAdjustment> precisionAdjustments) {
        this.precisionAdjustments = precisionAdjustments;
        ImmutableList.Builder elementProjectionFunctions = ImmutableList.builder();
        ImmutableList.Builder precisionProjectionFunctions = ImmutableList.builder();
        for (int i = 0; i < precisionAdjustments.size(); ++i) {
            elementProjectionFunctions.add((Object)new ElementProjectionFunction(i));
            precisionProjectionFunctions.add((Object)new PrecisionProjectionFunction(i));
        }
        this.elementProjectionFunctions = elementProjectionFunctions.build();
        this.precisionProjectionFunctions = precisionProjectionFunctions.build();
    }

    @Override
    public Triple<AbstractElement, Precision, PrecisionAdjustment.Action> prec(AbstractElement pElement, Precision pPrecision, UnmodifiableReachedSet pElements) throws CPAException {
        CompositeElement comp = (CompositeElement)pElement;
        CompositePrecision prec = (CompositePrecision)pPrecision;
        assert (comp.getWrappedElements().size() == prec.getPrecisions().size());
        int dim = comp.getWrappedElements().size();
        ImmutableList.Builder outElements = ImmutableList.builder();
        ImmutableList.Builder outPrecisions = ImmutableList.builder();
        boolean modified = false;
        PrecisionAdjustment.Action action = PrecisionAdjustment.Action.CONTINUE;
        for (int i = 0; i < dim; ++i) {
            UnmodifiableReachedSetView slice = new UnmodifiableReachedSetView(pElements, (Function<? super AbstractElement, AbstractElement>)((Function)this.elementProjectionFunctions.get(i)), (Function<? super Precision, Precision>)((Function)this.precisionProjectionFunctions.get(i)));
            PrecisionAdjustment precisionAdjustment = (PrecisionAdjustment)this.precisionAdjustments.get(i);
            AbstractElement oldElement = comp.get(i);
            Precision oldPrecision = prec.get(i);
            Triple<AbstractElement, Precision, PrecisionAdjustment.Action> out = precisionAdjustment.prec(oldElement, oldPrecision, slice);
            AbstractElement newElement = (AbstractElement)out.getFirst();
            Precision newPrecision = (Precision)out.getSecond();
            if (out.getThird() == PrecisionAdjustment.Action.BREAK) {
                action = PrecisionAdjustment.Action.BREAK;
            }
            if (newElement != oldElement || newPrecision != oldPrecision) {
                modified = true;
            }
            outElements.add((Object)newElement);
            outPrecisions.add((Object)newPrecision);
        }
        AbstractElement outElement = modified ? new CompositeElement((List<AbstractElement>)outElements.build()) : pElement;
        Precision outPrecision = modified ? new CompositePrecision((List<Precision>)outPrecisions.build()) : pPrecision;
        return new Triple((Object)outElement, (Object)outPrecision, (Object)action);
    }

    protected static class PrecisionProjectionFunction
    implements Function<Precision, Precision> {
        private final int dimension;

        public PrecisionProjectionFunction(int d) {
            this.dimension = d;
        }

        public Precision apply(Precision from) {
            return ((CompositePrecision)from).get(this.dimension);
        }
    }

    protected static class ElementProjectionFunction
    implements Function<AbstractElement, AbstractElement> {
        private final int dimension;

        public ElementProjectionFunction(int d) {
            this.dimension = d;
        }

        public AbstractElement apply(AbstractElement from) {
            return ((CompositeElement)from).get(this.dimension);
        }
    }
}

