/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.composite;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.cfa.blocks.Block;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Reducer;
import org.sosy_lab.cpachecker.cpa.composite.CompositeElement;
import org.sosy_lab.cpachecker.cpa.composite.CompositePrecision;

public class CompositeReducer
implements Reducer {
    private final List<Reducer> wrappedReducers;

    public CompositeReducer(List<Reducer> pWrappedReducers) {
        this.wrappedReducers = pWrappedReducers;
    }

    @Override
    public AbstractElement getVariableReducedElement(AbstractElement pExpandedElement, Block pContext, CFANode pLocation) {
        ArrayList<AbstractElement> result = new ArrayList<AbstractElement>();
        int i = 0;
        for (AbstractElement expandedElement : ((CompositeElement)pExpandedElement).getWrappedElements()) {
            result.add(this.wrappedReducers.get(i++).getVariableReducedElement(expandedElement, pContext, pLocation));
        }
        return new CompositeElement(result);
    }

    @Override
    public AbstractElement getVariableExpandedElement(AbstractElement pRootElement, Block pReducedContext, AbstractElement pReducedElement) {
        Iterable rootElements = ((CompositeElement)pRootElement).getWrappedElements();
        Iterable reducedElements = ((CompositeElement)pReducedElement).getWrappedElements();
        ArrayList<AbstractElement> result = new ArrayList<AbstractElement>();
        int i = 0;
        for (Pair p : Pair.zipList((Collection)rootElements, (Collection)reducedElements)) {
            result.add(this.wrappedReducers.get(i++).getVariableExpandedElement((AbstractElement)p.getFirst(), pReducedContext, (AbstractElement)p.getSecond()));
        }
        return new CompositeElement(result);
    }

    @Override
    public Object getHashCodeForElement(AbstractElement pElementKey, Precision pPrecisionKey) {
        Iterable elements = ((CompositeElement)pElementKey).getWrappedElements();
        List<Precision> precisions = ((CompositePrecision)pPrecisionKey).getPrecisions();
        ArrayList<Object> result = new ArrayList<Object>(elements.size());
        int i = 0;
        for (Pair p : Pair.zipList((Collection)elements, precisions)) {
            result.add(this.wrappedReducers.get(i++).getHashCodeForElement((AbstractElement)p.getFirst(), (Precision)p.getSecond()));
        }
        return result;
    }

    @Override
    public Precision getVariableReducedPrecision(Precision pPrecision, Block pContext) {
        List<Precision> precisions = ((CompositePrecision)pPrecision).getPrecisions();
        ArrayList<Precision> result = new ArrayList<Precision>(precisions.size());
        int i = 0;
        for (Precision precision : precisions) {
            result.add(this.wrappedReducers.get(i++).getVariableReducedPrecision(precision, pContext));
        }
        return new CompositePrecision(result);
    }

    @Override
    public Precision getVariableExpandedPrecision(Precision pRootPrecision, Block pRootContext, Precision pReducedPrecision) {
        List<Precision> rootPrecisions = ((CompositePrecision)pRootPrecision).getPrecisions();
        List<Precision> reducedPrecisions = ((CompositePrecision)pReducedPrecision).getPrecisions();
        ArrayList<Precision> result = new ArrayList<Precision>(rootPrecisions.size());
        int i = 0;
        for (Precision rootPrecision : rootPrecisions) {
            result.add(this.wrappedReducers.get(i).getVariableExpandedPrecision(rootPrecision, pRootContext, reducedPrecisions.get(i)));
            ++i;
        }
        return new CompositePrecision(result);
    }

    @Override
    public int measurePrecisionDifference(Precision pPrecision, Precision pOtherPrecision) {
        List<Precision> precisions = ((CompositePrecision)pPrecision).getPrecisions();
        List<Precision> otherPrecisions = ((CompositePrecision)pOtherPrecision).getPrecisions();
        int i = 0;
        int sum = 0;
        for (Precision rootPrecision : precisions) {
            sum += this.wrappedReducers.get(i).measurePrecisionDifference(rootPrecision, otherPrecisions.get(i));
            ++i;
        }
        return sum;
    }
}

