/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.composite;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.ProofChecker;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.cpa.composite.CompositeElement;
import org.sosy_lab.cpachecker.cpa.composite.CompositePrecision;
import org.sosy_lab.cpachecker.exceptions.CPAException;

public class CompositeStopOperator
implements StopOperator {
    protected final ImmutableList<StopOperator> stopOperators;

    public CompositeStopOperator(ImmutableList<StopOperator> stopOperators) {
        this.stopOperators = stopOperators;
    }

    @Override
    public boolean stop(AbstractElement element, Collection<AbstractElement> reached, Precision precision) throws CPAException {
        CompositeElement compositeElement = (CompositeElement)element;
        CompositePrecision compositePrecision = (CompositePrecision)precision;
        for (AbstractElement e : reached) {
            if (!this.stop(compositeElement, (CompositeElement)e, compositePrecision)) continue;
            return true;
        }
        return false;
    }

    private boolean stop(CompositeElement compositeElement, CompositeElement compositeReachedElement, CompositePrecision compositePrecision) throws CPAException {
        Iterable compositeElements = compositeElement.getWrappedElements();
        Iterable compositeReachedElements = compositeReachedElement.getWrappedElements();
        List<Precision> compositePrecisions = compositePrecision.getPrecisions();
        for (int idx = 0; idx < compositeElements.size(); ++idx) {
            StopOperator stopOp = (StopOperator)this.stopOperators.get(idx);
            AbstractElement absElem1 = (AbstractElement)compositeElements.get(idx);
            AbstractElement absElem2 = (AbstractElement)compositeReachedElements.get(idx);
            Precision prec = compositePrecisions.get(idx);
            if (stopOp.stop(absElem1, Collections.singleton(absElem2), prec)) continue;
            return false;
        }
        return true;
    }

    boolean isCoveredBy(AbstractElement pElement, AbstractElement pOtherElement, List<ConfigurableProgramAnalysis> cpas) throws CPAException {
        CompositeElement compositeElement = (CompositeElement)pElement;
        CompositeElement compositeOtherElement = (CompositeElement)pOtherElement;
        Iterable componentElements = compositeElement.getWrappedElements();
        Iterable componentOtherElements = compositeOtherElement.getWrappedElements();
        if (componentElements.size() != cpas.size()) {
            return false;
        }
        for (int idx = 0; idx < componentElements.size(); ++idx) {
            AbstractElement absElem2;
            AbstractElement absElem1;
            ProofChecker componentProofChecker = (ProofChecker)((Object)cpas.get(idx));
            if (componentProofChecker.isCoveredBy(absElem1 = (AbstractElement)componentElements.get(idx), absElem2 = (AbstractElement)componentOtherElements.get(idx))) continue;
            return false;
        }
        return true;
    }
}

