/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.composite;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.ProofChecker;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.assumptions.storage.AssumptionStorageTransferRelation;
import org.sosy_lab.cpachecker.cpa.composite.CompositeElement;
import org.sosy_lab.cpachecker.cpa.composite.CompositePrecision;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateTransferRelation;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.AbstractElements;

public class CompositeTransferRelation
implements TransferRelation {
    protected final ImmutableList<TransferRelation> transferRelations;
    protected final int size;
    private int assumptionIndex = -1;
    private int predicatesIndex = -1;

    public CompositeTransferRelation(ImmutableList<TransferRelation> transferRelations) {
        this.transferRelations = transferRelations;
        this.size = transferRelations.size();
        for (int i = 0; i < this.size; ++i) {
            TransferRelation t = (TransferRelation)transferRelations.get(i);
            if (t instanceof PredicateTransferRelation) {
                this.predicatesIndex = i;
            }
            if (!(t instanceof AssumptionStorageTransferRelation)) continue;
            this.assumptionIndex = i;
        }
    }

    public Collection<CompositeElement> getAbstractSuccessors(AbstractElement element, Precision precision, CFAEdge cfaEdge) throws CPATransferException, InterruptedException {
        ArrayList<CompositeElement> results;
        CompositeElement compositeElement = (CompositeElement)element;
        CompositePrecision compositePrecision = (CompositePrecision)precision;
        if (cfaEdge == null) {
            CFANode node = AbstractElements.extractLocation(compositeElement);
            results = new ArrayList(node.getNumLeavingEdges());
            for (int edgeIdx = 0; edgeIdx < node.getNumLeavingEdges(); ++edgeIdx) {
                CFAEdge edge = node.getLeavingEdge(edgeIdx);
                this.getAbstractSuccessorForEdge(compositeElement, compositePrecision, edge, results);
            }
        } else {
            results = new ArrayList<CompositeElement>(1);
            this.getAbstractSuccessorForEdge(compositeElement, compositePrecision, cfaEdge, results);
        }
        return results;
    }

    private void getAbstractSuccessorForEdge(CompositeElement compositeElement, CompositePrecision compositePrecision, CFAEdge cfaEdge, Collection<CompositeElement> compositeSuccessors) throws CPATransferException, InterruptedException {
        Precision lCurrentPrecision;
        AbstractElement lCurrentElement;
        TransferRelation lCurrentTransfer;
        Collection<? extends AbstractElement> componentSuccessors;
        assert (cfaEdge != null);
        int resultCount = 1;
        Iterable componentElements = compositeElement.getWrappedElements();
        ArrayList<Collection<? extends AbstractElement>> allComponentsSuccessors = new ArrayList<Collection<? extends AbstractElement>>(this.size);
        for (int i = 0; i < this.size && (resultCount *= (componentSuccessors = (lCurrentTransfer = (TransferRelation)this.transferRelations.get(i)).getAbstractSuccessors(lCurrentElement = (AbstractElement)componentElements.get(i), lCurrentPrecision = compositePrecision.get(i), cfaEdge)).size()) != 0; ++i) {
            allComponentsSuccessors.add(componentSuccessors);
        }
        Collection<List<AbstractElement>> allResultingElements = CompositeTransferRelation.createCartesianProduct(allComponentsSuccessors, resultCount);
        for (List<AbstractElement> lReachedElement : allResultingElements) {
            ArrayList<Collection<? extends AbstractElement>> lStrengthenResults = new ArrayList<Collection<? extends AbstractElement>>(this.size);
            resultCount = 1;
            for (int i = 0; i < this.size; ++i) {
                Precision lCurrentPrecision2;
                AbstractElement lCurrentElement2;
                TransferRelation lCurrentTransfer2 = (TransferRelation)this.transferRelations.get(i);
                Collection<? extends AbstractElement> lResultsList = lCurrentTransfer2.strengthen(lCurrentElement2 = lReachedElement.get(i), lReachedElement, cfaEdge, lCurrentPrecision2 = compositePrecision.get(i));
                if (lResultsList == null) {
                    lStrengthenResults.add(Collections.singleton(lCurrentElement2));
                    continue;
                }
                if ((resultCount *= lResultsList.size()) == 0) break;
                lStrengthenResults.add(lResultsList);
            }
            if (this.predicatesIndex >= 0 && this.assumptionIndex >= 0 && resultCount > 0) {
                AbstractElement predElement = (AbstractElement)Iterables.getOnlyElement((Iterable)((Iterable)lStrengthenResults.get(this.predicatesIndex)));
                AbstractElement assumptionElement = (AbstractElement)Iterables.getOnlyElement((Iterable)((Iterable)lStrengthenResults.get(this.assumptionIndex)));
                Precision predPrecision = compositePrecision.get(this.predicatesIndex);
                TransferRelation predTransfer = (TransferRelation)this.transferRelations.get(this.predicatesIndex);
                Collection<? extends AbstractElement> predResult = predTransfer.strengthen(predElement, Collections.singletonList(assumptionElement), cfaEdge, predPrecision);
                resultCount *= predResult.size();
                lStrengthenResults.set(this.predicatesIndex, predResult);
            }
            Collection<List<AbstractElement>> lResultingElements = CompositeTransferRelation.createCartesianProduct(lStrengthenResults, resultCount);
            for (List<AbstractElement> lList : lResultingElements) {
                compositeSuccessors.add(new CompositeElement(lList));
            }
        }
    }

    protected static Collection<List<AbstractElement>> createCartesianProduct(List<Collection<? extends AbstractElement>> allComponentsSuccessors, int resultCount) {
        Collection<List<AbstractElement>> allResultingElements;
        switch (resultCount) {
            case 0: {
                allResultingElements = Collections.emptySet();
                break;
            }
            case 1: {
                ArrayList<Object> resultingElements = new ArrayList<Object>(allComponentsSuccessors.size());
                for (Collection<? extends AbstractElement> componentSuccessors : allComponentsSuccessors) {
                    resultingElements.add(Iterables.getOnlyElement(componentSuccessors));
                }
                allResultingElements = Collections.singleton(resultingElements);
                break;
            }
            default: {
                List<AbstractElement> initialPrefix = Collections.emptyList();
                allResultingElements = new ArrayList(resultCount);
                CompositeTransferRelation.createCartesianProduct0(allComponentsSuccessors, initialPrefix, allResultingElements);
            }
        }
        assert (resultCount == allResultingElements.size());
        return allResultingElements;
    }

    private static void createCartesianProduct0(List<Collection<? extends AbstractElement>> allComponentsSuccessors, List<AbstractElement> prefix, Collection<List<AbstractElement>> allResultingElements) {
        if (prefix.size() == allComponentsSuccessors.size()) {
            allResultingElements.add(prefix);
        } else {
            int depth = prefix.size();
            Collection<? extends AbstractElement> myComponentsSuccessors = allComponentsSuccessors.get(depth);
            for (AbstractElement abstractElement : myComponentsSuccessors) {
                ArrayList<AbstractElement> newPrefix = new ArrayList<AbstractElement>(prefix);
                newPrefix.add(abstractElement);
                CompositeTransferRelation.createCartesianProduct0(allComponentsSuccessors, newPrefix, allResultingElements);
            }
        }
    }

    @Override
    public Collection<? extends AbstractElement> strengthen(AbstractElement element, List<AbstractElement> otherElements, CFAEdge cfaEdge, Precision precision) {
        return null;
    }

    boolean areAbstractSuccessors(AbstractElement pElement, CFAEdge pCfaEdge, Collection<? extends AbstractElement> pSuccessors, List<ConfigurableProgramAnalysis> cpas) throws CPATransferException, InterruptedException {
        Preconditions.checkNotNull((Object)pCfaEdge);
        CompositeElement compositeElement = (CompositeElement)pElement;
        int resultCount = 1;
        boolean result = true;
        for (int i = 0; i < this.size; ++i) {
            HashSet<AbstractElement> componentSuccessors = new HashSet<AbstractElement>();
            for (AbstractElement abstractElement : pSuccessors) {
                CompositeElement compositeSuccessor = (CompositeElement)abstractElement;
                if (compositeSuccessor.getNumberofElements() != this.size) {
                    return false;
                }
                componentSuccessors.add(compositeSuccessor.get(i));
            }
            resultCount *= componentSuccessors.size();
            ProofChecker componentProofChecker = (ProofChecker)((Object)cpas.get(i));
            if (!componentProofChecker.areAbstractSuccessors(compositeElement.get(i), pCfaEdge, componentSuccessors)) {
                result = false;
                continue;
            }
            if (!componentSuccessors.isEmpty()) continue;
            assert (pSuccessors.isEmpty());
            return true;
        }
        if (resultCount != pSuccessors.size()) {
            return false;
        }
        return result;
    }
}

