/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.conditions.global;

import java.util.Collection;
import java.util.logging.Level;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.FlatLatticeDomain;
import org.sosy_lab.cpachecker.core.defaults.IdentityTransferRelation;
import org.sosy_lab.cpachecker.core.defaults.MergeSepOperator;
import org.sosy_lab.cpachecker.core.defaults.NoOpReducer;
import org.sosy_lab.cpachecker.core.defaults.SingletonAbstractElement;
import org.sosy_lab.cpachecker.core.defaults.SingletonPrecision;
import org.sosy_lab.cpachecker.core.defaults.StaticPrecisionAdjustment;
import org.sosy_lab.cpachecker.core.defaults.StopAlwaysOperator;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysisWithABM;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.ProofChecker;
import org.sosy_lab.cpachecker.core.interfaces.Reducer;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.conditions.AdjustableConditionCPA;
import org.sosy_lab.cpachecker.cpa.conditions.global.GlobalConditionsPrecisionAdjustment;
import org.sosy_lab.cpachecker.cpa.conditions.global.GlobalConditionsSimplePrecisionAdjustment;
import org.sosy_lab.cpachecker.cpa.conditions.global.GlobalConditionsThresholds;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;

public class GlobalConditionsCPA
implements ConfigurableProgramAnalysisWithABM,
AdjustableConditionCPA,
ProofChecker {
    private final PrecisionAdjustment precisionAdjustment;
    private final GlobalConditionsThresholds thresholds;
    private final AbstractDomain domain;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(GlobalConditionsCPA.class);
    }

    private GlobalConditionsCPA(Configuration config, LogManager logger) throws InvalidConfigurationException {
        this.thresholds = new GlobalConditionsThresholds(config, logger);
        if (this.thresholds.isLimitEnabled()) {
            logger.log(Level.INFO, new Object[]{"Analyzing with the following", this.thresholds});
            GlobalConditionsSimplePrecisionAdjustment prec = new GlobalConditionsSimplePrecisionAdjustment(logger, this.thresholds);
            this.precisionAdjustment = this.thresholds.getReachedSetSizeThreshold() >= 0 ? new GlobalConditionsPrecisionAdjustment(logger, this.thresholds, prec) : prec;
        } else {
            this.precisionAdjustment = StaticPrecisionAdjustment.getInstance();
        }
        this.domain = new FlatLatticeDomain(SingletonAbstractElement.INSTANCE);
    }

    @Override
    public boolean adjustPrecision() {
        return this.thresholds.adjustPrecision();
    }

    @Override
    public AbstractElement getInitialElement(CFANode pNode) {
        return SingletonAbstractElement.INSTANCE;
    }

    @Override
    public Precision getInitialPrecision(CFANode pNode) {
        return SingletonPrecision.getInstance();
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return this.domain;
    }

    @Override
    public MergeOperator getMergeOperator() {
        return MergeSepOperator.getInstance();
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return this.precisionAdjustment;
    }

    @Override
    public StopOperator getStopOperator() {
        return StopAlwaysOperator.getInstance();
    }

    @Override
    public TransferRelation getTransferRelation() {
        return IdentityTransferRelation.INSTANCE;
    }

    @Override
    public Reducer getReducer() {
        return NoOpReducer.getInstance();
    }

    @Override
    public boolean areAbstractSuccessors(AbstractElement pElement, CFAEdge pCfaEdge, Collection<? extends AbstractElement> pSuccessors) throws CPATransferException, InterruptedException {
        return pSuccessors.size() == 1 && pSuccessors.contains(pElement);
    }

    @Override
    public boolean isCoveredBy(AbstractElement pElement, AbstractElement pOtherElement) throws CPAException {
        return pElement == pOtherElement;
    }
}

