/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.conditions.global;

import java.util.logging.Level;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.Triple;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.conditions.global.GlobalConditionsSimplePrecisionAdjustment;
import org.sosy_lab.cpachecker.cpa.conditions.global.GlobalConditionsThresholds;
import org.sosy_lab.cpachecker.exceptions.CPAException;

class GlobalConditionsPrecisionAdjustment
implements PrecisionAdjustment {
    private final LogManager logger;
    private final GlobalConditionsThresholds thresholds;
    private final GlobalConditionsSimplePrecisionAdjustment delegate;

    GlobalConditionsPrecisionAdjustment(LogManager pLogger, GlobalConditionsThresholds pThresholds, GlobalConditionsSimplePrecisionAdjustment pDelegate) {
        this.logger = pLogger;
        this.thresholds = pThresholds;
        this.delegate = pDelegate;
    }

    @Override
    public Triple<AbstractElement, Precision, PrecisionAdjustment.Action> prec(AbstractElement pElement, Precision pPrecision, UnmodifiableReachedSet pElements) throws CPAException {
        if (this.checkReachedSetSize(pElements)) {
            this.logger.log(Level.WARNING, new Object[]{"Reached set size threshold reached, terminating."});
            return Triple.of((Object)pElement, (Object)pPrecision, (Object)((Object)PrecisionAdjustment.Action.BREAK));
        }
        return Triple.of((Object)pElement, (Object)pPrecision, (Object)((Object)this.delegate.prec(pElement, pPrecision)));
    }

    private boolean checkReachedSetSize(UnmodifiableReachedSet elements) {
        long threshold = this.thresholds.getReachedSetSizeThreshold();
        if (threshold >= 0L) {
            return (long)elements.size() > threshold;
        }
        return false;
    }
}

