/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.conditions.path;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.sosy_lab.common.Files;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.IntegerOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.ast.IASTAssignment;
import org.sosy_lab.cpachecker.cfa.ast.IASTDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.IASTExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.IASTIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.IASTStatement;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.StatementEdge;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.conditions.AvoidanceReportingElement;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.conditions.path.PathCondition;
import org.sosy_lab.cpachecker.cpa.explicit.ExplicitElement;
import org.sosy_lab.cpachecker.util.assumptions.PreventingHeuristic;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaManager;

@Options(prefix="cpa.conditions.path.assignments")
public class AssignmentsInPathCondition
implements PathCondition,
Statistics {
    @Option(description="maximum number of assignments (-1 for infinite)")
    @IntegerOption(min=-1L)
    private int threshold = -1;
    @Option(description="whether or not to track unique assignments only")
    private boolean demandUniqueness = true;
    @Option(name="extendedStatsFile", description="file name where to put the extended stats file")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private File extendedStatsFile;
    private AssignmentsInPathConditionElement currentElement = null;
    private int maxNumberOfAssignments = 0;
    private Map<String, Integer> maxNumberOfAssignmentsPerIdentifier = new HashMap<String, Integer>();
    LogManager logger;

    public AssignmentsInPathCondition(Configuration config, LogManager logger) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.logger = logger;
    }

    @Override
    public AvoidanceReportingElement getInitialElement(CFANode node) {
        AssignmentsInPathConditionElement element = this.demandUniqueness ? new UniqueAssignmentsInPathConditionElement() : new AllAssignmentsInPathConditionElement();
        return element;
    }

    @Override
    public AvoidanceReportingElement getAbstractSuccessor(AbstractElement element, CFAEdge edge) {
        IASTExpression leftHandSide;
        String assignedVariable;
        StatementEdge statementEdge;
        IASTStatement statement;
        this.currentElement = (AssignmentsInPathConditionElement)element;
        if (edge.getEdgeType() == CFAEdgeType.StatementEdge && (statement = (statementEdge = (StatementEdge)edge).getStatement()) instanceof IASTAssignment && (assignedVariable = this.getScopedVariableName(leftHandSide = ((IASTAssignment)((Object)statement)).getLeftHandSide(), edge)) != null) {
            this.currentElement = this.currentElement.getSuccessor(assignedVariable);
        }
        this.maxNumberOfAssignments = Math.max(this.maxNumberOfAssignments, this.currentElement.maximum);
        for (Map.Entry<String, Integer> assignment : this.currentElement.getAssignmentCounts().entrySet()) {
            String variableName = assignment.getKey();
            Integer currentCounter = this.maxNumberOfAssignmentsPerIdentifier.containsKey(variableName) ? this.maxNumberOfAssignmentsPerIdentifier.get(variableName) : 0;
            currentCounter = Math.max(currentCounter, assignment.getValue());
            this.maxNumberOfAssignmentsPerIdentifier.put(variableName, currentCounter);
        }
        return this.currentElement;
    }

    private String getScopedVariableName(IASTExpression expression, CFAEdge edge) {
        String scope = "";
        if (!this.isGlobalIdentifier(expression)) {
            scope = edge.getPredecessor().getFunctionName() + "::";
        }
        if (expression instanceof IASTIdExpression || expression instanceof IASTFieldReference) {
            return scope + expression.toASTString();
        }
        return null;
    }

    private boolean isGlobalIdentifier(IASTExpression expression) {
        IASTIdExpression identifier;
        IASTSimpleDeclaration declaration;
        if (expression instanceof IASTIdExpression && (declaration = (identifier = (IASTIdExpression)expression).getDeclaration()) instanceof IASTDeclaration) {
            return ((IASTDeclaration)declaration).isGlobal();
        }
        return false;
    }

    @Override
    public boolean adjustPrecision() {
        this.threshold *= 2;
        return true;
    }

    @Override
    public String getName() {
        return (this.demandUniqueness ? "unique" : "all") + " assignments in path condition";
    }

    @Override
    public void printStatistics(PrintStream out, CPAcheckerResult.Result result, ReachedSet reachedSet) {
        out.println("Threshold value: " + this.threshold);
        out.println("max. number of assignments: " + this.maxNumberOfAssignments);
        if (this.extendedStatsFile != null) {
            this.writeLogFile();
        }
    }

    private void writeLogFile() {
        try {
            StringBuilder builder = new StringBuilder();
            builder.append("total number of variable assignments of last element:");
            builder.append("\n");
            builder.append(this.currentElement);
            builder.append("\n");
            builder.append("\n");
            builder.append("max. total number of variable assignments over all elements:");
            builder.append("\n");
            builder.append(AssignmentsInPathCondition.assignmentsAsString(this.maxNumberOfAssignmentsPerIdentifier));
            Files.writeFile((File)this.extendedStatsFile, (Object)builder.toString());
        }
        catch (IOException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write extended statistics to file");
        }
    }

    private static String assignmentsAsString(Map<String, Integer> assignments) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, Integer> assignment : assignments.entrySet()) {
            builder.append(assignment.getKey());
            builder.append(" -> ");
            builder.append(assignment.getValue());
            builder.append("\n");
        }
        return builder.toString();
    }

    public class UniqueAssignmentsInPathConditionElement
    extends AssignmentsInPathConditionElement {
        private Multimap<String, Long> mapping;
        private String assignedVariable;

        public UniqueAssignmentsInPathConditionElement() {
            this.mapping = HashMultimap.create();
            this.assignedVariable = null;
        }

        private UniqueAssignmentsInPathConditionElement(UniqueAssignmentsInPathConditionElement original) {
            this.mapping = HashMultimap.create();
            this.assignedVariable = null;
            this.mapping = HashMultimap.create(original.mapping);
            this.maximum = original.maximum;
        }

        @Override
        public UniqueAssignmentsInPathConditionElement getSuccessor(String assignedVariable) {
            UniqueAssignmentsInPathConditionElement successor = new UniqueAssignmentsInPathConditionElement(this);
            successor.assignedVariable = assignedVariable;
            return successor;
        }

        public void addAssignment(ExplicitElement element) {
            Long value;
            if (this.assignedVariable == null) {
                return;
            }
            if (element.contains(this.assignedVariable) && (value = element.getValueFor(this.assignedVariable)) != null) {
                this.mapping.put((Object)this.assignedVariable, (Object)value);
                this.maximum = Math.max(this.maximum, this.getAssignmentCount(this.assignedVariable));
            }
        }

        @Override
        public boolean variableExceedsGivenLimit(String variableName, Integer limit) {
            return this.mapping.containsKey((Object)variableName) && this.getAssignmentCount(variableName) >= limit;
        }

        @Override
        public Integer getAssignmentCount(String variableName) {
            return this.mapping.get((Object)variableName).size();
        }

        @Override
        public Map<String, Integer> getAssignmentCounts() {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            for (String variableName : this.mapping.keys()) {
                map.put(variableName, this.getAssignmentCount(variableName));
            }
            return Collections.unmodifiableMap(map);
        }
    }

    public class AllAssignmentsInPathConditionElement
    extends AssignmentsInPathConditionElement {
        private HashMap<String, Integer> mapping;

        public AllAssignmentsInPathConditionElement() {
            this.mapping = new HashMap();
        }

        private AllAssignmentsInPathConditionElement(AllAssignmentsInPathConditionElement original) {
            this.mapping = new HashMap();
            this.mapping = new HashMap<String, Integer>(original.mapping);
            this.maximum = original.maximum;
        }

        @Override
        public AllAssignmentsInPathConditionElement getSuccessor(String assignedVariable) {
            AllAssignmentsInPathConditionElement successor = new AllAssignmentsInPathConditionElement(this);
            Integer numberOfAssignments = this.mapping.containsKey(assignedVariable) ? this.mapping.get(assignedVariable) + 1 : 1;
            successor.mapping.put(assignedVariable, numberOfAssignments);
            successor.maximum = Math.max(successor.maximum, numberOfAssignments);
            return successor;
        }

        @Override
        public boolean variableExceedsGivenLimit(String variableName, Integer limit) {
            return this.mapping.containsKey(variableName) && this.mapping.get(variableName) >= limit;
        }

        @Override
        public Integer getAssignmentCount(String variableName) {
            return this.mapping.get(variableName);
        }

        @Override
        public Map<String, Integer> getAssignmentCounts() {
            return Collections.unmodifiableMap(this.mapping);
        }
    }

    public abstract class AssignmentsInPathConditionElement
    implements AbstractElement,
    AvoidanceReportingElement {
        protected Integer maximum = 0;

        public abstract AssignmentsInPathConditionElement getSuccessor(String var1);

        public Integer getMaximum() {
            return this.maximum;
        }

        @Override
        public Formula getReasonFormula(FormulaManager formuaManager) {
            String formula = PreventingHeuristic.ASSIGNMENTSINPATH.getFormulaString(this.maximum.intValue());
            return formuaManager.parse(formula);
        }

        @Override
        public boolean mustDumpAssumptionForAvoidance() {
            return AssignmentsInPathCondition.this.threshold != -1 && this.maximum > AssignmentsInPathCondition.this.threshold;
        }

        public abstract boolean variableExceedsGivenLimit(String var1, Integer var2);

        public abstract Integer getAssignmentCount(String var1);

        public abstract Map<String, Integer> getAssignmentCounts();

        public String toString() {
            StringBuilder builder = new StringBuilder();
            return builder.append(AssignmentsInPathCondition.assignmentsAsString(this.getAssignmentCounts())).toString();
        }
    }
}

