/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.conditions.path;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.IntegerOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.conditions.AvoidanceReportingElement;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.conditions.path.PathCondition;
import org.sosy_lab.cpachecker.util.assumptions.PreventingHeuristic;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaManager;

@Options(prefix="cpa.conditions.path.repetitions")
public class RepetitionsInPathCondition
implements PathCondition,
Statistics {
    @Option(description="maximum repetitions of any edge in a path (-1 for infinite)", name="limit")
    @IntegerOption(min=-1L)
    private int threshold = -1;
    private int increaseThresholdBy = 0;
    private int maxRepetitionsInPath = 0;

    public RepetitionsInPathCondition(Configuration config, LogManager logger) throws InvalidConfigurationException {
        config.inject((Object)this);
    }

    @Override
    public AvoidanceReportingElement getInitialElement(CFANode pNode) {
        return new RepetitionsInPathConditionElement((Map)ImmutableMap.of(), this.threshold, false);
    }

    private boolean isInteresting(CFAEdge edge) {
        return edge.getEdgeType() == CFAEdgeType.FunctionCallEdge || edge.getPredecessor().isLoopStart();
    }

    @Override
    public AvoidanceReportingElement getAbstractSuccessor(AbstractElement pElement, CFAEdge pEdge) {
        Integer repetitions;
        RepetitionsInPathConditionElement element = (RepetitionsInPathConditionElement)pElement;
        if (!this.isInteresting(pEdge)) {
            return element;
        }
        if (element.thresholdReached) {
            return element;
        }
        Integer n = repetitions = (Integer)Objects.firstNonNull((Object)element.frequencyMap.get((Object)pEdge), (Object)0);
        Integer n2 = repetitions = Integer.valueOf(repetitions + 1);
        boolean thresholdReached = this.threshold >= 0 && repetitions >= this.threshold;
        this.maxRepetitionsInPath = Math.max(repetitions, this.maxRepetitionsInPath);
        HashMap newFrequencyMap = Maps.newHashMap((Map)element.frequencyMap);
        newFrequencyMap.put(pEdge, repetitions);
        return new RepetitionsInPathConditionElement(newFrequencyMap, this.threshold, thresholdReached);
    }

    @Override
    public boolean adjustPrecision() {
        if (this.threshold == -1) {
            this.increaseThresholdBy = this.threshold = this.maxRepetitionsInPath / 5;
        } else {
            this.threshold += this.increaseThresholdBy;
        }
        return true;
    }

    @Override
    public String getName() {
        return "Repetitions in path condition";
    }

    @Override
    public void printStatistics(PrintStream out, CPAcheckerResult.Result pResult, ReachedSet pReached) {
        out.println("Maximum repetitions in a path: " + this.maxRepetitionsInPath);
        out.println("Threshold value:               " + this.threshold);
    }

    private static class RepetitionsInPathConditionElement
    implements AbstractElement,
    AvoidanceReportingElement {
        private final ImmutableMap<CFAEdge, Integer> frequencyMap;
        private final int threshold;
        private final boolean thresholdReached;

        private RepetitionsInPathConditionElement(Map<CFAEdge, Integer> pFrequencyMap, int pThreshold, boolean pThresholdReached) {
            this.frequencyMap = ImmutableMap.copyOf(pFrequencyMap);
            this.threshold = pThreshold;
            this.thresholdReached = pThresholdReached;
        }

        @Override
        public boolean mustDumpAssumptionForAvoidance() {
            return this.thresholdReached;
        }

        @Override
        public Formula getReasonFormula(FormulaManager pMgr) {
            String formula = PreventingHeuristic.REPETITIONSINPATH.getFormulaString(this.threshold);
            return pMgr.parse(formula);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry entry : this.frequencyMap.entrySet()) {
                builder.append(entry.getValue()).append("x(").append(entry.getKey()).append(") ");
            }
            return builder.toString();
        }
    }
}

