/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.defuse;

import java.util.HashSet;
import java.util.List;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionDefinitionNode;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.MergeJoinOperator;
import org.sosy_lab.cpachecker.core.defaults.MergeSepOperator;
import org.sosy_lab.cpachecker.core.defaults.SingletonPrecision;
import org.sosy_lab.cpachecker.core.defaults.StaticPrecisionAdjustment;
import org.sosy_lab.cpachecker.core.defaults.StopSepOperator;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.defuse.DefUseDefinition;
import org.sosy_lab.cpachecker.cpa.defuse.DefUseDomain;
import org.sosy_lab.cpachecker.cpa.defuse.DefUseElement;
import org.sosy_lab.cpachecker.cpa.defuse.DefUseTransferRelation;

@Options(prefix="cpa.defuse")
public class DefUseCPA
implements ConfigurableProgramAnalysis {
    @Option(name="merge", values={"sep", "join"}, description="which merge operator to use for DefUseCPA")
    private String mergeType = "sep";
    private AbstractDomain abstractDomain;
    private TransferRelation transferRelation;
    private MergeOperator mergeOperator;
    private StopOperator stopOperator;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(DefUseCPA.class);
    }

    private DefUseCPA(Configuration config) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.abstractDomain = new DefUseDomain();
        this.transferRelation = new DefUseTransferRelation();
        this.mergeOperator = null;
        if (this.mergeType.equals("sep")) {
            this.mergeOperator = MergeSepOperator.getInstance();
        } else if (this.mergeType.equals("join")) {
            this.mergeOperator = new MergeJoinOperator(this.abstractDomain);
        }
        this.stopOperator = new StopSepOperator(this.abstractDomain);
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return this.abstractDomain;
    }

    @Override
    public TransferRelation getTransferRelation() {
        return this.transferRelation;
    }

    @Override
    public MergeOperator getMergeOperator() {
        return this.mergeOperator;
    }

    @Override
    public StopOperator getStopOperator() {
        return this.stopOperator;
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return StaticPrecisionAdjustment.getInstance();
    }

    @Override
    public AbstractElement getInitialElement(CFANode node) {
        HashSet<DefUseDefinition> defUseDefinitions = new HashSet<DefUseDefinition>();
        if (node instanceof FunctionDefinitionNode) {
            List<String> parameterNames = ((FunctionDefinitionNode)node).getFunctionParameterNames();
            for (String parameterName : parameterNames) {
                DefUseDefinition newDef = new DefUseDefinition(parameterName, null);
                defUseDefinitions.add(newDef);
            }
        }
        return new DefUseElement(defUseDefinitions);
    }

    @Override
    public Precision getInitialPrecision(CFANode pNode) {
        return SingletonPrecision.getInstance();
    }
}

