/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.defuse;

import com.google.common.collect.ImmutableSet;
import java.util.Iterator;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.cpa.defuse.DefUseDefinition;

public class DefUseElement
implements AbstractElement,
Iterable<DefUseDefinition> {
    private final Set<DefUseDefinition> definitions;

    public DefUseElement(Set<DefUseDefinition> definitions) {
        this.definitions = ImmutableSet.copyOf(definitions);
    }

    public DefUseElement(DefUseElement definitions, DefUseDefinition newDefinition) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)newDefinition);
        for (DefUseDefinition def : definitions.definitions) {
            if (def.getVariableName().equals(newDefinition.getVariableName())) continue;
            builder.add((Object)def);
        }
        this.definitions = builder.build();
    }

    @Override
    public Iterator<DefUseDefinition> iterator() {
        return this.definitions.iterator();
    }

    public boolean containsAllOf(DefUseElement other) {
        return this.definitions.containsAll(other.definitions);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DefUseElement)) {
            return false;
        }
        DefUseElement otherDefUse = (DefUseElement)other;
        return ((Object)otherDefUse.definitions).equals(this.definitions);
    }

    public int hashCode() {
        return ((Object)this.definitions).hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('{');
        boolean hasAny = false;
        for (DefUseDefinition def : this.definitions) {
            CFAEdge assigningEdge = def.getAssigningEdge();
            builder.append('(').append(def.getVariableName()).append(", ");
            if (assigningEdge != null) {
                builder.append(assigningEdge.getPredecessor().getNodeNumber());
            } else {
                builder.append(0);
            }
            builder.append(", ");
            if (assigningEdge != null) {
                builder.append(assigningEdge.getSuccessor().getNodeNumber());
            } else {
                builder.append(0);
            }
            builder.append("), ");
            hasAny = true;
        }
        if (hasAny) {
            builder.replace(builder.length() - 2, builder.length(), "}");
        } else {
            builder.append('}');
        }
        return builder.toString();
    }
}

