/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.defuse;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.ast.IASTAssignment;
import org.sosy_lab.cpachecker.cfa.ast.IASTInitializer;
import org.sosy_lab.cpachecker.cfa.ast.IASTStatement;
import org.sosy_lab.cpachecker.cfa.ast.IASTVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.DeclarationEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.StatementEdge;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.defuse.DefUseDefinition;
import org.sosy_lab.cpachecker.cpa.defuse.DefUseElement;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;

public class DefUseTransferRelation
implements TransferRelation {
    private DefUseElement handleExpression(DefUseElement defUseElement, IASTStatement expression, CFAEdge cfaEdge) {
        if (expression instanceof IASTAssignment) {
            IASTAssignment assignExpression = (IASTAssignment)((Object)expression);
            String lParam = assignExpression.getLeftHandSide().toASTString();
            DefUseDefinition definition = new DefUseDefinition(lParam, cfaEdge);
            defUseElement = new DefUseElement(defUseElement, definition);
        }
        return defUseElement;
    }

    private DefUseElement handleDeclaration(DefUseElement defUseElement, DeclarationEdge cfaEdge) {
        IASTVariableDeclaration decl;
        IASTInitializer initializer;
        if (cfaEdge.getDeclaration() instanceof IASTVariableDeclaration && (initializer = (decl = (IASTVariableDeclaration)cfaEdge.getDeclaration()).getInitializer()) != null) {
            String varName = decl.getName();
            DefUseDefinition definition = new DefUseDefinition(varName, cfaEdge);
            defUseElement = new DefUseElement(defUseElement, definition);
        }
        return defUseElement;
    }

    @Override
    public Collection<? extends AbstractElement> getAbstractSuccessors(AbstractElement element, Precision prec, CFAEdge cfaEdge) throws CPATransferException {
        DefUseElement defUseElement = (DefUseElement)element;
        switch (cfaEdge.getEdgeType()) {
            case StatementEdge: {
                StatementEdge statementEdge = (StatementEdge)cfaEdge;
                IASTStatement expression = statementEdge.getStatement();
                defUseElement = this.handleExpression(defUseElement, expression, cfaEdge);
                break;
            }
            case DeclarationEdge: {
                DeclarationEdge declarationEdge = (DeclarationEdge)cfaEdge;
                defUseElement = this.handleDeclaration(defUseElement, declarationEdge);
                break;
            }
        }
        return Collections.singleton(defUseElement);
    }

    @Override
    public Collection<? extends AbstractElement> strengthen(AbstractElement element, List<AbstractElement> otherElements, CFAEdge cfaEdge, Precision precision) {
        return null;
    }
}

