/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.dominator.parametric;

import java.util.HashSet;
import java.util.Iterator;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.cpa.dominator.parametric.DominatorElement;
import org.sosy_lab.cpachecker.exceptions.CPAException;

public class DominatorDomain
implements AbstractDomain {
    private final ConfigurableProgramAnalysis cpa;
    private static final DominatorTopElement topElement = new DominatorTopElement();

    public DominatorDomain(ConfigurableProgramAnalysis cpa) {
        this.cpa = cpa;
    }

    @Override
    public boolean isLessOrEqual(AbstractElement element1, AbstractElement element2) throws CPAException {
        if (element1.equals(element2)) {
            return true;
        }
        if (element2.equals(topElement)) {
            return true;
        }
        if (element1 instanceof DominatorElement && element2 instanceof DominatorElement) {
            DominatorElement dominatorElement1 = (DominatorElement)element1;
            DominatorElement dominatorElement2 = (DominatorElement)element2;
            if (this.cpa.getAbstractDomain().isLessOrEqual(dominatorElement1.getDominatedElement(), dominatorElement2.getDominatedElement())) {
                Iterator<AbstractElement> dominatorIterator = dominatorElement2.getIterator();
                while (dominatorIterator.hasNext()) {
                    AbstractElement dominator = dominatorIterator.next();
                    if (dominatorElement1.isDominatedBy(dominator)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public AbstractElement join(AbstractElement element1, AbstractElement element2) {
        if (!(element1 instanceof DominatorElement)) {
            throw new IllegalArgumentException("element1 is not a DominatorElement!");
        }
        if (!(element2 instanceof DominatorElement)) {
            throw new IllegalArgumentException("element2 is not a DominatorElement!");
        }
        DominatorElement dominatorElement1 = (DominatorElement)element1;
        DominatorElement dominatorElement2 = (DominatorElement)element2;
        if (element1.equals(topElement)) {
            return dominatorElement1;
        }
        if (element2.equals(topElement)) {
            return dominatorElement2;
        }
        if (!dominatorElement1.getDominatedElement().equals(dominatorElement2.getDominatedElement())) {
            return topElement;
        }
        HashSet<AbstractElement> intersectingDominators = new HashSet<AbstractElement>();
        Iterator<AbstractElement> dominatorIterator = dominatorElement1.getIterator();
        while (dominatorIterator.hasNext()) {
            AbstractElement dominator = dominatorIterator.next();
            if (!dominatorElement2.isDominatedBy(dominator)) continue;
            intersectingDominators.add(dominator);
        }
        DominatorElement result = new DominatorElement(dominatorElement1.getDominatedElement(), intersectingDominators);
        result.update(dominatorElement1.getDominatedElement());
        return result;
    }

    private static class DominatorTopElement
    extends DominatorElement {
        private DominatorTopElement() {
        }

        @Override
        public String toString() {
            return "\\bot";
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof DominatorTopElement;
        }

        @Override
        public int hashCode() {
            return Integer.MIN_VALUE;
        }

        @Override
        public CFANode getLocationNode() {
            return null;
        }
    }
}

