/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.dominator.parametric;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElementWithLocation;

public class DominatorElement
implements AbstractElementWithLocation,
AbstractElement {
    private AbstractElement dominatedElement;
    private Set<AbstractElement> dominators = new HashSet<AbstractElement>();

    public DominatorElement(AbstractElement dominatedElement) {
        if (dominatedElement == null) {
            throw new IllegalArgumentException("dominatedElement is null!");
        }
        this.dominatedElement = dominatedElement;
    }

    public DominatorElement(AbstractElement dominatedElement, Set<AbstractElement> dominators) {
        this(dominatedElement);
        if (dominators == null) {
            throw new IllegalArgumentException("dominators is null!");
        }
        this.dominators.addAll(dominators);
    }

    protected DominatorElement() {
        this.dominatedElement = null;
    }

    public DominatorElement(DominatorElement other) {
        this(other.dominatedElement, other.dominators);
    }

    public DominatorElement(AbstractElement dominatedElement, DominatorElement other) {
        this(dominatedElement, other.dominators);
    }

    public void update(AbstractElement dominator) {
        if (dominator == null) {
            throw new IllegalArgumentException("dominator is null!");
        }
        this.dominators.add(dominator);
    }

    public AbstractElement getDominatedElement() {
        return this.dominatedElement;
    }

    public Iterator<AbstractElement> getIterator() {
        return this.dominators.iterator();
    }

    public boolean isDominatedBy(AbstractElement dominator) {
        return this.dominators.contains(dominator);
    }

    public boolean equals(Object other) {
        if (!(other instanceof DominatorElement)) {
            return false;
        }
        DominatorElement other_element = (DominatorElement)other;
        if (!this.dominatedElement.equals(other_element.dominatedElement)) {
            return false;
        }
        if (this.dominators.size() != other_element.dominators.size()) {
            return false;
        }
        for (AbstractElement dominator : this.dominators) {
            if (other_element.isDominatedBy(dominator)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("( " + this.dominatedElement.toString() + ", {");
        boolean first = true;
        for (AbstractElement dominator : this.dominators) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append(dominator.toString());
        }
        builder.append("})");
        return builder.toString();
    }

    @Override
    public CFANode getLocationNode() {
        return ((AbstractElementWithLocation)this.dominatedElement).getLocationNode();
    }

    public int hashCode() {
        return this.dominatedElement.hashCode();
    }
}

