/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.dominator.parametric;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.dominator.parametric.DominatorElement;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;

public class DominatorTransferRelation
implements TransferRelation {
    private final ConfigurableProgramAnalysis cpa;

    public DominatorTransferRelation(ConfigurableProgramAnalysis cpa) {
        if (cpa == null) {
            throw new IllegalArgumentException("cpa is null!");
        }
        this.cpa = cpa;
    }

    public Collection<DominatorElement> getAbstractSuccessors(AbstractElement element, Precision prec, CFAEdge cfaEdge) throws CPATransferException, InterruptedException {
        assert (element instanceof DominatorElement);
        DominatorElement dominatorElement = (DominatorElement)element;
        Collection<? extends AbstractElement> successorsOfDominatedElement = this.cpa.getTransferRelation().getAbstractSuccessors(dominatorElement.getDominatedElement(), prec, cfaEdge);
        ArrayList<DominatorElement> successors = new ArrayList<DominatorElement>(successorsOfDominatedElement.size());
        for (AbstractElement abstractElement : successorsOfDominatedElement) {
            DominatorElement successor = new DominatorElement(abstractElement, dominatorElement);
            successor.update(abstractElement);
            successors.add(successor);
        }
        return successors;
    }

    @Override
    public Collection<? extends AbstractElement> strengthen(AbstractElement element, List<AbstractElement> otherElements, CFAEdge cfaEdge, Precision precision) {
        return null;
    }
}

