/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.explicit;

import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.MergeJoinOperator;
import org.sosy_lab.cpachecker.core.defaults.MergeSepOperator;
import org.sosy_lab.cpachecker.core.defaults.StaticPrecisionAdjustment;
import org.sosy_lab.cpachecker.core.defaults.StopJoinOperator;
import org.sosy_lab.cpachecker.core.defaults.StopNeverOperator;
import org.sosy_lab.cpachecker.core.defaults.StopSepOperator;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysisWithABM;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.Reducer;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.explicit.ExplicitDomain;
import org.sosy_lab.cpachecker.cpa.explicit.ExplicitElement;
import org.sosy_lab.cpachecker.cpa.explicit.ExplicitPrecision;
import org.sosy_lab.cpachecker.cpa.explicit.ExplicitReducer;
import org.sosy_lab.cpachecker.cpa.explicit.ExplicitTransferRelation;

@Options(prefix="cpa.explicit")
public class ExplicitCPA
implements ConfigurableProgramAnalysisWithABM {
    @Option(name="merge", toUppercase=true, values={"SEP", "JOIN"}, description="which merge operator to use for ExplicitCPA")
    private String mergeType = "SEP";
    @Option(name="stop", toUppercase=true, values={"SEP", "JOIN", "NEVER"}, description="which stop operator to use for ExplicitCPA")
    private String stopType = "SEP";
    @Option(name="variableBlacklist", description="blacklist regex for variables that won't be tracked by ExplicitCPA")
    private String variableBlacklist = "";
    private ExplicitPrecision precision;
    private AbstractDomain abstractDomain;
    private MergeOperator mergeOperator;
    private StopOperator stopOperator;
    private TransferRelation transferRelation;
    private PrecisionAdjustment precisionAdjustment;
    private final ExplicitReducer reducer;
    private final Configuration config;
    private final LogManager logger;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(ExplicitCPA.class);
    }

    private ExplicitCPA(Configuration config, LogManager logger) throws InvalidConfigurationException {
        this.config = config;
        this.logger = logger;
        config.inject((Object)this);
        this.abstractDomain = new ExplicitDomain();
        this.transferRelation = new ExplicitTransferRelation(config);
        this.precision = this.initializePrecision(config);
        this.mergeOperator = this.initializeMergeOperator();
        this.stopOperator = this.initializeStopOperator();
        this.precisionAdjustment = StaticPrecisionAdjustment.getInstance();
        this.reducer = new ExplicitReducer();
    }

    private MergeOperator initializeMergeOperator() {
        if (this.mergeType.equals("SEP")) {
            return MergeSepOperator.getInstance();
        }
        if (this.mergeType.equals("JOIN")) {
            return new MergeJoinOperator(this.abstractDomain);
        }
        return null;
    }

    private StopOperator initializeStopOperator() {
        if (this.stopType.equals("SEP")) {
            return new StopSepOperator(this.abstractDomain);
        }
        if (this.stopType.equals("JOIN")) {
            return new StopJoinOperator(this.abstractDomain);
        }
        if (this.stopType.equals("NEVER")) {
            return new StopNeverOperator();
        }
        return null;
    }

    private ExplicitPrecision initializePrecision(Configuration config) throws InvalidConfigurationException {
        return new ExplicitPrecision(this.variableBlacklist, config);
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return this.abstractDomain;
    }

    @Override
    public MergeOperator getMergeOperator() {
        return this.mergeOperator;
    }

    @Override
    public StopOperator getStopOperator() {
        return this.stopOperator;
    }

    @Override
    public TransferRelation getTransferRelation() {
        return this.transferRelation;
    }

    @Override
    public AbstractElement getInitialElement(CFANode node) {
        return new ExplicitElement();
    }

    @Override
    public Precision getInitialPrecision(CFANode pNode) {
        return this.precision;
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return this.precisionAdjustment;
    }

    protected Configuration getConfiguration() {
        return this.config;
    }

    protected LogManager getLogger() {
        return this.logger;
    }

    @Override
    public Reducer getReducer() {
        return this.reducer;
    }
}

