/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.explicit;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.cpachecker.core.interfaces.AbstractQueryableElement;
import org.sosy_lab.cpachecker.core.interfaces.FormulaReportingElement;
import org.sosy_lab.cpachecker.exceptions.InvalidQueryException;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaManager;

public class ExplicitElement
implements AbstractQueryableElement,
FormulaReportingElement,
Serializable {
    private static final long serialVersionUID = -3152134511524554357L;
    private final Map<String, Long> constantsMap;
    private final ExplicitElement previousElement;

    ExplicitElement() {
        this.constantsMap = new HashMap<String, Long>();
        this.previousElement = null;
    }

    ExplicitElement(ExplicitElement previousElement) {
        this.constantsMap = new HashMap<String, Long>();
        this.previousElement = previousElement;
    }

    private ExplicitElement(Map<String, Long> constantsMap, ExplicitElement previousElement) {
        this.constantsMap = constantsMap;
        this.previousElement = previousElement;
    }

    void assignConstant(String variableName, Long value) {
        this.constantsMap.put((String)Preconditions.checkNotNull((Object)variableName), (Long)Preconditions.checkNotNull((Object)value));
    }

    void forget(String variableName) {
        this.constantsMap.remove(variableName);
    }

    public Long getValueFor(String variableName) {
        return (Long)Preconditions.checkNotNull((Object)this.constantsMap.get(variableName));
    }

    public boolean contains(String variableName) {
        return this.constantsMap.containsKey(variableName);
    }

    ExplicitElement getPreviousElement() {
        return this.previousElement;
    }

    public int getSize() {
        return this.constantsMap.size();
    }

    ExplicitElement join(ExplicitElement other) {
        int size = Math.min(this.constantsMap.size(), other.constantsMap.size());
        HashMap<String, Long> newConstantsMap = new HashMap<String, Long>(size);
        for (Map.Entry<String, Long> otherEntry : other.constantsMap.entrySet()) {
            String key = otherEntry.getKey();
            if (!Objects.equal((Object)otherEntry.getValue(), (Object)this.constantsMap.get(key))) continue;
            newConstantsMap.put(key, otherEntry.getValue());
        }
        return new ExplicitElement(newConstantsMap, this.previousElement);
    }

    boolean isLessOrEqual(ExplicitElement other) {
        if (this.previousElement != other.previousElement) {
            return false;
        }
        if (this.constantsMap.size() < other.constantsMap.size()) {
            return false;
        }
        for (Map.Entry<String, Long> otherEntry : other.constantsMap.entrySet()) {
            String key = otherEntry.getKey();
            if (otherEntry.getValue().equals(this.constantsMap.get(key))) continue;
            return false;
        }
        return true;
    }

    public ExplicitElement clone() {
        return new ExplicitElement(new HashMap<String, Long>(this.constantsMap), this.previousElement);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        ExplicitElement otherElement = (ExplicitElement)other;
        return otherElement.previousElement == this.previousElement && ((Object)otherElement.constantsMap).equals(this.constantsMap);
    }

    public int hashCode() {
        return ((Object)this.constantsMap).hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (Map.Entry<String, Long> entry : this.constantsMap.entrySet()) {
            String key = entry.getKey();
            sb.append(" <");
            sb.append(key);
            sb.append(" = ");
            sb.append(entry.getValue());
            sb.append(">\n");
        }
        return sb.append("] size->  ").append(this.constantsMap.size()).toString();
    }

    public String toCompactString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        boolean first = true;
        for (Map.Entry<String, Long> entry : this.constantsMap.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            String key = entry.getKey();
            sb.append(key);
            sb.append("=");
            sb.append(entry.getValue());
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public Object evaluateProperty(String pProperty) throws InvalidQueryException {
        if ((pProperty = pProperty.trim()).startsWith("contains(")) {
            String varName = pProperty.substring("contains(".length(), pProperty.length() - 1);
            return this.constantsMap.containsKey(varName);
        }
        String[] parts = pProperty.split("==");
        if (parts.length != 2) {
            Long value = this.constantsMap.get(pProperty);
            if (value != null) {
                return value;
            }
            throw new InvalidQueryException("The Query \"" + pProperty + "\" is invalid. Could not find the variable \"" + pProperty + "\"");
        }
        return this.checkProperty(pProperty);
    }

    @Override
    public boolean checkProperty(String pProperty) throws InvalidQueryException {
        String[] parts = pProperty.split("==");
        if (parts.length != 2) {
            throw new InvalidQueryException("The Query \"" + pProperty + "\" is invalid. Could not split the property string correctly.");
        }
        Long value = this.constantsMap.get(parts[0]);
        if (value == null) {
            return false;
        }
        try {
            return value == Long.parseLong(parts[1]);
        }
        catch (NumberFormatException e) {
            throw new InvalidQueryException("The Query \"" + pProperty + "\" is invalid. Could not parse the long \"" + parts[1] + "\"");
        }
    }

    @Override
    public void modifyProperty(String pModification) throws InvalidQueryException {
        Preconditions.checkNotNull((Object)pModification);
        String[] statements = pModification.split(";");
        for (int i = 0; i < statements.length; ++i) {
            String statement = statements[i].trim().toLowerCase();
            if (statement.startsWith("deletevalues(")) {
                if (!statement.endsWith(")")) {
                    throw new InvalidQueryException(statement + " should end with \")\"");
                }
                String varName = statement.substring("deletevalues(".length(), statement.length() - 1);
                Long x = this.constantsMap.remove(varName);
                if (x != null) continue;
            }
            if (!statement.startsWith("setvalue(")) continue;
            if (!statement.endsWith(")")) {
                throw new InvalidQueryException(statement + " should end with \")\"");
            }
            String assignment = statement.substring("setvalue(".length(), statement.length() - 1);
            String[] assignmentParts = assignment.split(":=");
            if (assignmentParts.length != 2) {
                throw new InvalidQueryException("The Query \"" + pModification + "\" is invalid. Could not split the property string correctly.");
            }
            String varName = assignmentParts[0].trim();
            try {
                long newValue = Long.parseLong(assignmentParts[1].trim());
                this.assignConstant(varName, newValue);
                continue;
            }
            catch (NumberFormatException e) {
                throw new InvalidQueryException("The Query \"" + pModification + "\" is invalid. Could not parse the long \"" + assignmentParts[1].trim() + "\"");
            }
        }
    }

    @Override
    public String getCPAName() {
        return "ExplicitAnalysis";
    }

    @Override
    public Formula getFormulaApproximation(FormulaManager manager) {
        Formula formula = manager.makeTrue();
        for (Map.Entry<String, Long> entry : this.constantsMap.entrySet()) {
            Formula var = manager.makeVariable(entry.getKey());
            Formula val = manager.makeNumber(entry.getValue().toString());
            formula = manager.makeAnd(formula, manager.makeEqual(var, val));
        }
        return formula;
    }

    void deleteValue(String varName) {
        this.constantsMap.remove(varName);
    }

    Set<String> getTrackedVariableNames() {
        return this.constantsMap.keySet();
    }

    Map<String, Long> getConstantsMap() {
        return this.constantsMap;
    }
}

