/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.explicit;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.Precision;

@Options(prefix="cpa.explicit.precision")
public class ExplicitPrecision
implements Precision {
    private final Pattern blackListPattern;
    private CFANode currentLocation = null;
    private ReachedSetThresholds reachedSetThresholds = null;
    private PathThresholds pathThresholds = null;
    private CegarPrecision cegarPrecision = null;

    public ExplicitPrecision(String variableBlacklist, Configuration config) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.blackListPattern = Pattern.compile(variableBlacklist);
        this.cegarPrecision = new CegarPrecision(config);
        this.reachedSetThresholds = new ReachedSetThresholds(config);
        this.pathThresholds = new PathThresholds(config);
    }

    public ExplicitPrecision(ExplicitPrecision original) {
        this.blackListPattern = original.blackListPattern;
        this.cegarPrecision = new CegarPrecision(original.cegarPrecision);
        this.reachedSetThresholds = new ReachedSetThresholds(original.reachedSetThresholds);
        this.pathThresholds = new PathThresholds(original.pathThresholds);
    }

    public CegarPrecision getCegarPrecision() {
        return this.cegarPrecision;
    }

    public ReachedSetThresholds getReachedSetThresholds() {
        return this.reachedSetThresholds;
    }

    public PathThresholds getPathThresholds() {
        return this.pathThresholds;
    }

    public void setLocation(CFANode node) {
        this.currentLocation = node;
    }

    boolean isOnBlacklist(String variable) {
        return this.blackListPattern.matcher(variable).matches();
    }

    public boolean isTracking(String variable) {
        return this.reachedSetThresholds.allowsTrackingOf(variable) && this.pathThresholds.allowsTrackingOf(variable) && this.cegarPrecision.allowsTrackingOf(variable) && !this.blackListPattern.matcher(variable).matches();
    }

    public boolean isNotTracking(String variable) {
        return !this.isTracking(variable);
    }

    public String getBlackListPattern() {
        return this.blackListPattern.pattern();
    }

    @Options(prefix="cpa.explicit.precision.path")
    class PathThresholds
    extends Thresholds {
        @Option(description="threshold for amount of different values that are tracked for one variable per path (-1 means infinitely)")
        protected Integer defaultThreshold;

        private PathThresholds(Configuration config) throws InvalidConfigurationException {
            this.defaultThreshold = -1;
            config.inject((Object)this);
        }

        private PathThresholds(PathThresholds original) {
            this.defaultThreshold = -1;
            this.defaultThreshold = original.defaultThreshold;
            this.thresholds = new HashMap(original.thresholds);
        }

        boolean exceeds(String variable, Integer count) {
            if (this.defaultThreshold == -1) {
                return false;
            }
            return this.thresholds.containsKey(variable) && this.thresholds.get(variable) == null || this.thresholds.containsKey(variable) && (Integer)this.thresholds.get(variable) < count || !this.thresholds.containsKey(variable) && this.defaultThreshold < count;
        }
    }

    @Options(prefix="cpa.explicit.precision.reachedSet")
    class ReachedSetThresholds
    extends Thresholds {
        @Option(description="threshold for amount of different values that are tracked for one variable within the reached set (-1 means infinitely)")
        protected Integer defaultThreshold;

        private ReachedSetThresholds(Configuration config) throws InvalidConfigurationException {
            this.defaultThreshold = -1;
            config.inject((Object)this);
        }

        private ReachedSetThresholds(ReachedSetThresholds original) {
            this.defaultThreshold = -1;
            this.defaultThreshold = original.defaultThreshold;
            this.thresholds = new HashMap(original.thresholds);
        }

        boolean exceeds(String variable, Integer count) {
            if (this.defaultThreshold == -1) {
                return false;
            }
            return this.thresholds.containsKey(variable) && this.thresholds.get(variable) == null || this.thresholds.containsKey(variable) && (Integer)this.thresholds.get(variable) < count || !this.thresholds.containsKey(variable) && this.defaultThreshold < count;
        }
    }

    abstract class Thresholds {
        protected HashMap<String, Integer> thresholds = new HashMap();

        Thresholds() {
        }

        boolean allowsTrackingOf(String variable) {
            return !this.thresholds.containsKey(variable) || this.thresholds.get(variable) != null;
        }

        void setExceeded(String variable) {
            this.thresholds.put(variable, null);
        }
    }

    @Options(prefix="analysis")
    class CegarPrecision {
        private SetMultimap<CFANode, String> mapping = null;
        @Option(description="whether or not to use refinement or not")
        private boolean useRefinement = false;

        private CegarPrecision(Configuration config) throws InvalidConfigurationException {
            config.inject((Object)this);
            if (this.useRefinement) {
                this.mapping = HashMultimap.create();
            }
        }

        private CegarPrecision(CegarPrecision original) {
            if (original.mapping != null) {
                this.mapping = HashMultimap.create(original.mapping);
            }
        }

        boolean allowsTrackingOf(String variable) {
            return this.mapping == null || this.mapping.containsEntry((Object)ExplicitPrecision.this.currentLocation, (Object)variable);
        }

        void addToMapping(SetMultimap<CFANode, String> additionalMapping) {
            this.mapping.putAll(additionalMapping);
        }
    }
}

